#!/bin/sh

start_up=$(ps -ef | grep Restart | grep -v grep)
if [ ! -n "$start_up" ]; then
    exit 0
fi


program_restart=0
network_restart=0

echo "" > /var/db/dhclient.leases
/root/NXServer/shell/Fans.sh &
/root/NXServer/shell/tcpUp.sh &

NetworkApp="/root/NXServer"
Net="NetworkManager*"
Netlog="NetworkManager.log"
ShellPath="/root/NXServer/shell/"
binPath="/root/NXServer/bin/"
LogPath="/root/NXServer/log/"
restartLog="restart_info.log"
ethSer="ETH_server*"
NetworkAppUp="/root/NXServer.zip"

>$LogPath$restartLog  #Emptying the restart_info.log file
fileMaxByte=1048576
DhcpConfigByte=500

error_maxNum=60    #Maximum number of consecutive missing ip or program exceptions。
error_num=0         #Number of consecutive missing ip or program exceptions。
NoHaveConf=0
MaxErrorConf=10
while true
do

    #Determine if the network cable is connected
    network=`ifconfig br0|grep "RUNNING"`

    #network disconnection
    if [ "$network" == "" ]; then
        # kill Running ETH_server
        program_id=`ps | grep $ethSer | grep -v grep | sed 's/^\s*//' | sed 's/[[:space:]].*//'`

        if [ "$program_id" == "" ]; then
            sleep 0.1
        else
            kill $program_id
            
            network_restart=`expr $network_restart + 1`
            time=`date +%Y-%m-%d,%H:%m:%S`
            echo "Number of network disconnections and restarts:$network_restart Network disconnection restart time:$time" >> $LogPath$restartLog
        fi
    #network connection
    else
    
        NetworkRun=`ps | grep $Net | grep -v grep | sed 's/^\s*//' | sed 's/[[:space:]].*//'`
        #Determine if the current net is still running。
        if [ -n "$NetworkRun" ];then
            program=`ps -ef|grep ETH_server|grep -v grep`
            if [ -n "$program" ]; then
                sleep 0.5
            else
                sleep 1
            fi
        else
            setsid $binPath$Net  >> $LogPath$Netlog 2>&1 &
            sleep 2
        fi

        ETH_RUN=`ps | grep ETH | grep -v grep | sed 's/^\s*//' | sed 's/[[:space:]].*//'`
        
        if [ -n "$ETH_RUN" ];then
            sleep 0.1
        else
            setsid ${binPath}${ethSer} >>  $LogPath$restartLog 2>&1 &
        fi          
        

        if [ -f "/root/NX_update.txt" ]; then
            kill -9 $ETH_RUN
            rm -r /root/NXServer/
            unzip -o /root/NXServer.zip  -d /root/
            rm /root/NX_update.txt
            setsid sh /root/NXServer/update.sh &
            sleep 1
            rm /root/NXServer.zip
            exit 0
        fi
        
        ip_num=$(ip addr show br0 | awk '/inet / {print $1}' | wc -l)
        if [ "$ip_num" -eq 2 ];then
            error_num=0
        else
            error_num=$((error_num + 1))
            if [ "$error_num" -eq "$error_maxNum" ];then
                NetworkRun=`ps | grep $Net | grep -v grep | sed 's/^\s*//' | sed 's/[[:space:]].*//'`
                kill $NetworkRun
                error_num=0
                echo "num == 0 Shut down Net and clear it." >> $LogPath$Netlog 
            fi
        fi
        
        fileByte=$(stat -c %s /root/NXServer/log/NetworkManager.log)
        if [ "$fileByte" -gt "$fileMaxByte" ];then
            echo " " > $LogPath$Netlog
        fi

    fi

    sleep 0.5    #Check every 0.5 seconds to see if the network and ETH_server are running.

    srcFile="/root/NXServer/config/dhclient_copy.conf"
    dstFile="/etc/dhclient.conf"
    
    srcFileSize=$(stat -c %s "$srcFile")
    
    dstFileSize=$(stat -c %s "$dstFile")
    
    if [ "$srcFileSize" -gt "$dstFileSize" ]; then
        cat "$srcFile" > "$dstFile"
        echo "Updated $dstFile with $srcFile" >> $LogPath$Netlog
    fi

done        
