#!/bin/sh
CURDIR=`pwd`

A=`whoami`


if [ $A != 'root' ]; then
   echo "You have to be root to run this script"
   exit 1;
fi

file=$( ls ./lib/libhtraapi.so.* )
file=$( basename $file )
version=${file#*so.}
majornum=${version%%.*}

rm -f /etc/harogicusb.conf
rm -f /etc/udev/rules.d/harogic-cyusb.rules
rm -f /etc/htrausb.conf
rm -f /etc/udev/rules.d/htra-cyusb.rules

rm -f /usr/lib/libhtraapi.so*

rm -f /usr/lib/libusb-1.0.so*

rm -f /usr/lib/libliquid.so*

cp configs/htrausb.conf /etc/
cp configs/htra-cyusb.rules /etc/udev/rules.d/

cp lib/libhtraapi.so.${version} /usr/lib/
ln -sf /usr/lib/libhtraapi.so.${version} /usr/lib/libhtraapi.so.${majornum}
ln -sf /usr/lib/libhtraapi.so.${majornum} /usr/lib/libhtraapi.so

cp lib/libusb-1.0.so.0.2.0 /usr/lib/
ln -sf /usr/lib/libusb-1.0.so.0.2.0 /usr/lib/libusb-1.0.so.0
ln -sf /usr/lib/libusb-1.0.so.0 /usr/lib/libusb-1.0.so

cp lib/libliquid.so /usr/lib/

cp lib/libgomp.so.1.0.0 /usr/lib/
ln -sf /usr/lib/libgomp.so.1.0.0 /usr/lib/libgomp.so.1
ln -sf /usr/lib/libgomp.so.1 /usr/lib/libgomp.so