remove_oem() {
   OEM_UUID=$(lsblk -o NAME,LABEL,UUID | grep "oem" | awk '{print $3}')

   if [ -z "$OEM_UUID" ]; then
      echo "No OEM partition found."
   else
      echo "UUID: $OEM_UUID"

      MOUNT_POINT=$(lsblk -o UUID,MOUNTPOINT | grep "$OEM_UUID" | awk '{print $2}')

      if [ -n "$MOUNT_POINT" ]; then
         echo "Unmounting: $MOUNT_POINT"
         sudo umount "$MOUNT_POINT"
      else
         echo "OEM partition is not mounted."
      fi

      FSTAB_LINE="UUID=$OEM_UUID none ext4 noauto 0 0"
      if ! grep -q "$OEM_UUID" /etc/fstab; then
         echo "Updating /etc/fstab"
         echo "$FSTAB_LINE" | sudo tee -a /etc/fstab
      else
         echo "OEM partition already in /etc/fstab."
      fi
   fi
}

remove_oem