﻿#define EXAMPLE_MACRO_NAME
#include "htra_api.h"


int Device_GetDeviceInfo(); //获取设备信息，包括：API版本、USB版本、设备型号、设备UID、MCU版本、FPGA版本和设备温度。
int Device_SysPowerState(); //设置设备待机状态的范例，可以设置为正常工作状态和射频处于下电状态（低功耗）。
int Device_AboutGNSS();     //获取GNSS模块获取的经纬度、海拔和时间等信息，获取SWP模式下MeasAuxInfo中GNSS相关的经纬度和时间信息，获取IQS模式下IQStream.DeviceState中的经纬度和时间信息。
int Device_GetAndSetIP();   //获取设备IP地址，并通过设备UID或者设备当前的IP修改IP地址。
int Device_MeasureModeSwitchTime(); //获取当前上位机切换不同模式所需要的时间。


int SWP_GetSpectrum_Standard();	  //通过调用函数接口获取频谱数据。
int SWP_EZGetPartialSweep();	  //使用简洁配置快速获取频谱数据。
int SWP_MaxHold_MinHold();        //将迹线模式设置为MaxHold或MinHold，并使用SWP_ResetTraceHold重置保持。
int SWP_TraceAverage();           //对获取迹线进行平均处理。
int SWP_AutoSetMeasure();	      //根据具体SWP应用，自动配置相关参数，通过下发自动配置参数，完成测量。
int SWP_SetFreqCompensation();    //当存在外接衰减器时，可对相应频段进行补偿，使得测试结果依然准确。
int SWP_TimeOfSetFunction();      //获取SWP模式下不同函数的耗时。
int SWP_PickMaxPower();           //获取当前频谱的最大功率点与其对应的频率点。
int SWP_GetSpectrum_SigAndSpur(); //可以在获取频谱数据后区分信号和杂散。
int SWP_GetSpectrumAndIQS();      //同时获取频谱数据与IQ数据。
int SWP_GNSSReferenceClock();     //在SWP模式下使用高品质GNSS模块的10MHz参考时钟。
int SWP_GetSpectrum_Trigger();    //可以获取在触发源设置为外触发时的频谱数据。
int SWP_GetSpectrum_TraceAlign(); //在迹线对齐方式为对齐至起始频率或对齐至中心频率时，获取频谱数据。
int SWP_Fixedtime_GetFrames();    //循环50次获取10s频谱数据，得出在10s内能获取的平均频谱帧数。
int SWP_CalibrateRefClock();      //设备通过GNSS-1PPS或者通过Ext触发进行Clock校准。


int IQS_GetIQ_EZStandard();            //使用简洁配置快速获取频谱数据。
int IQS_GetIQ_Standard();              //在专业配置下获取固定点数或连续流的IQ数据。
int IQS_ScaleIQDataToVolts();          //将获取的IQ数据转换为以V为单位的数据。
int IQS_ConfigandGetIQ_Time();         //获取IQS_Configuration、IQS_GetIQStream_PM1函数的调用耗时。
int IQS_AudioAnalysis();               //对解调之后的IQ数据进行音频分析，得到音频电压、音频频率、信纳德和总谐波失真。
int IQS_GetIQToTxt();                  //将获得的IQ数据写入.txt文件中。
int IQS_Multithread_GetIQ_FFT_Write(); //多线程获取IQ数据、对IQ数据做FFT、将IQ数据写入txt文件。
int IQS_GNSS_1PPS();                   //在IQS模式下使用GNSS模块的1PPS触发。
int IQS_MultiDevSync_fixed();          //多台设备在同一时刻同时采集同一信号。     
int IQS_ExternalTrigger();             //配置触发源为外部触发
int IQS_TimerTrigger();                //配置触发源为定时器触发
int IQS_LevelTrigger();                //配置触发源为电平触发。
int IQS_Enable_GNSS_10MHz();           //在IQS模式下使用高品质GNSS模块的10MHz参考时钟。


int DSP_IQSToSpectrum(); //将获取到的时域IQ数据通过频谱分析方法转换为频谱数据。
int DSP_DDC();           //对获取的IQ数据进行重采样。
int DSP_LPF();           //对获取的IQ数据进行低通滤波。


int DETMode_EZStandard(); //通过简洁配置快速获取检波数据。
int DETMode_Standard();   //获取固定点数或连续流的检波数据。


int RTAMode_EZStandard();        //简洁配置快速获取检波数据。
int RTAMode_Standard();          //获取固定点数（时长）或连续流的实时频谱数据。
int RTAMode_Standard_perframe(); //获取100帧数据，并计算每帧的平均处理时间。


int ASG_SignalOutput(); //按需输出单音/扫频/功率扫描信号。


void Device_Open_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo); //设备打开过程中的异常处理
void SWP_Configuration_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, SWP_Profile_TypeDef* SWP_ProfileIn, SWP_Profile_TypeDef* SWP_ProfileOut, SWP_TraceInfo_TypeDef* TraceInfo);				 //SWP模式配置参数时的异常处理
void IQS_Configuration_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, IQS_Profile_TypeDef* IQS_ProfileIn, IQS_Profile_TypeDef* IQS_ProfileOut, IQS_StreamInfo_TypeDef* StreamInfo);				 //IQS模式配置参数时的异常处理
void DET_Configuration_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, DET_Profile_TypeDef* DET_ProfileIn, DET_Profile_TypeDef* DET_ProfileOut, DET_StreamInfo_TypeDef* StreamInfo);				 //DET模式配置参数时的异常处理
void RTA_Configuration_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, RTA_Profile_TypeDef* RTA_ProfileIn, RTA_Profile_TypeDef* RTA_ProfileOut, RTA_FrameInfo_TypeDef* FrameInfo);				 //RTA模式配置参数时的异常处理
void SWP_ErrorHandlingExceptOpenAndConfiguration(int& Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, SWP_Profile_TypeDef* SWP_ProfileIn, SWP_Profile_TypeDef* SWP_ProfileOut, SWP_TraceInfo_TypeDef* TraceInfo);	 //SWP模式除打开设备和配置参数外其他函数调用的异常处理
void IQS_ErrorHandlingExceptOpenAndConfiguration(int& Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, IQS_Profile_TypeDef* IQS_ProfileIn, IQS_Profile_TypeDef* IQS_ProfileOut, IQS_StreamInfo_TypeDef* StreamInfo); //IQS模式除打开设备和配置参数外其他函数调用的异常处理
void DET_ErrorHandlingExceptOpenAndConfiguration(int& Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, DET_Profile_TypeDef* DET_ProfileIn, DET_Profile_TypeDef* DET_ProfileOut, DET_StreamInfo_TypeDef* StreamInfo); //DET模式除打开设备和配置参数外其他函数调用的异常处理
void RTA_ErrorHandlingExceptOpenAndConfiguration(int& Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, RTA_Profile_TypeDef* RTA_ProfileIn, RTA_Profile_TypeDef* RTA_ProfileOut, RTA_FrameInfo_TypeDef* FrameInfo);	 //RTA模式除打开设备和配置参数外其他函数调用的异常处理
