﻿#include <stdio.h>
#include <string.h>
#include <chrono>
#include <windows.h>
#include <iostream>
#include <vector>
#include <sstream>
#include <string>
#include "example.h"
#include "htra_api.h"
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int SWP_TimeOfSetFunction()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	std::chrono::duration<double, std::milli> timeofspan; //消耗的时间。
	double Speed;									      //扫速。
	double ThroughPut;                                    //吞吐量。

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo);              //打开设备。

	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	SWP_Profile_TypeDef SWP_ProfileIn;  //SWP输入配置，包括起始频率、终止频率、RBW、参考电平等。
	SWP_Profile_TypeDef SWP_ProfileOut; //SWP输出配置。
	SWP_TraceInfo_TypeDef TraceInfo;    //当前配置下的迹线信息，包括迹线点数、跳频点数等。

	SWP_ProfileDeInit(&Device, &SWP_ProfileIn); //初始化SWP模式的相关参数。

	SWP_ProfileIn.StartFreq_Hz = 9e3;                         //起始频率。
	SWP_ProfileIn.StopFreq_Hz = 6.37e9;                       //终止频率。
	SWP_ProfileIn.RBWMode = RBW_Manual;                       //手动RBW。
	SWP_ProfileIn.RBW_Hz = 300e3;                             //配置RBW。
	//SWP_ProfileIn.TraceDetectMode = TraceDetectMode_Manual; //手动迹线检波。
	//SWP_ProfileIn.TraceDetector = TraceDetector_RMS;        //RMS检波。
	//SWP_ProfileIn.SweepTimeMode = SWTMode_minSWT;           //最短扫频时间扫描。

	auto start1 = std::chrono::high_resolution_clock::now();                                                                        //获取当前时间。
	Status = SWP_Configuration(&Device, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo);                                               //通过调用此函数下发SWP模式的相关配置。

	SWP_Configuration_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	auto stop1 = std::chrono::high_resolution_clock::now();
	auto timeout1 = std::chrono::duration_cast<std::chrono::duration<double, ratio<1, 1000>>>(stop1 - start1);
	cout << "SWP_Configuration Completed" << endl;
	cout << "SWP_Configuration Cost：" << timeout1.count() << "ms" << endl;

	vector<double> Frequency(TraceInfo.FullsweepTracePoints);    //创建频率数组。
	vector<float> PowerSpec_dBm(TraceInfo.FullsweepTracePoints); //创建功率数组。
	int HopIndex = 0;                                            //当前跳频点索引。
	int FrameIndex = 0;                                          //当前帧索引。
	MeasAuxInfo_TypeDef MeasAuxInfo;                             //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

	while (1)
	{
		auto start2 = std::chrono::high_resolution_clock::now();
		for (int i = 0; i < TraceInfo.TotalHops; i++)                //TraceInfo.TotalHops代表当前配置下的帧数，因此循环TraceInfo.TotalHops次调用SWP_GetPartialSweep即可得到完整迹线。
		{
			Status = SWP_GetPartialSweep(&Device, Frequency.data() + i * TraceInfo.PartialsweepTracePoints, PowerSpec_dBm.data() + i * TraceInfo.PartialsweepTracePoints, &HopIndex, &FrameIndex, &MeasAuxInfo); //获取频谱数据。
			
			SWP_ErrorHandlingExceptOpenAndConfiguration(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。                                                         //当Status不为0时，根据Status的返回值进行相对应的错误处理
		}
		auto stop2 = std::chrono::high_resolution_clock::now();                                                    //获取当前时间。
		auto timeout2 = std::chrono::duration_cast<std::chrono::duration<double, ratio<1, 1000>>>(stop2 - start2); //计算时间差。	
		cout << "SWP_GetPartialSweep Completed" << endl;																	
		cout << "SWP_GetPartialSweep Cost：" << timeout2.count() << "ms" << endl;
		timeofspan = timeout2;
		Speed = (SWP_ProfileIn.Span_Hz / timeofspan.count()) * 1e3;                                                //计算扫速。
		cout << "Current Sweep Time:" << Speed << "Hz/s" << std::endl;
		ThroughPut =(((TraceInfo.FullsweepTracePoints * 12) / timeofspan.count())*1e3) / 1024;                     //计算吞吐量。（（迹线点数*12）/时间）/1024
		cout << "Current ThroughPut:" << ThroughPut << "KB/s" << std::endl;
	}

	Device_Close(&Device); //关闭设备。

	return 0;
}