﻿#include <stdio.h>
#include <string.h>
#include <vector>
#include <fstream>
#include<chrono>
#include<vector>
#include<iostream>
#include "example.h"
#include "htra_api.h"
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int SWP_GetSpectrumAndIQS()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。
	void* I_Data = NULL;
	void* Q_Data = NULL;

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。
	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理
	

	SWP_EZProfile_TypeDef SWP_ProfileIn;  //SWP输入配置，包括起始频率、终止频率、RBW、参考电平等。
	SWP_EZProfile_TypeDef SWP_ProfileOut; //SWP输出配置。
	SWP_TraceInfo_TypeDef TraceInfo;      //当前配置下的迹线信息，包括迹线点数、跳频点数等。

	SWP_EZProfileDeInit(&Device, &SWP_ProfileIn); //调用此函数初始化配置SWP模式的相关参数。

	SWP_ProfileIn.StartFreq_Hz = 1e9;           //配置起始频率。
	SWP_ProfileIn.StopFreq_Hz = 2e9;            //配置终止频率。
	SWP_ProfileIn.RBW_Hz = 300e3;               //配置RBW。 
	SWP_ProfileIn.TraceType = ClearWriteWithIQ; //设置迹线类型，同时获取IQ数据与频谱数据。


	Status = SWP_EZConfiguration(&Device, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //通过调用此函数下发SWP模式的相关配置。

	SWPTrace_TypeDef PartialTrace;

	// 在采样率小于31.25M后，为了保证动态，数据类型将由int16改为int32
	if (TraceInfo.DataFormat == Complex16bit)
	{
		PartialTrace.AlternIQStream = (int16_t*)malloc(TraceInfo.SamplePoints * 2 * sizeof(int16_t));
		I_Data = (int16_t*)malloc(TraceInfo.SamplePoints * sizeof(int16_t)); //开辟空间存储I路数据。
		Q_Data = (int16_t*)malloc(TraceInfo.SamplePoints * sizeof(int16_t)); //开辟空间存储Q路数据。
	}
	else
	{
		PartialTrace.AlternIQStream = (int32_t*)malloc(TraceInfo.SamplePoints * 2 * sizeof(int32_t));
		I_Data = (int32_t*)malloc(TraceInfo.SamplePoints * sizeof(int32_t)); //开辟空间存储I路数据。
		Q_Data = (int32_t*)malloc(TraceInfo.SamplePoints * sizeof(int32_t)); //开辟空间存储Q路数据。
	}

	vector<double> Frequency(TraceInfo.FullsweepTracePoints);    //动态建立数组，存放整条频率数据。
	vector<float> PowerSpec_dBm(TraceInfo.FullsweepTracePoints); //动态建立数组，存放整条幅度数据。

	PartialTrace.Freq_Hz = new double[TraceInfo.PartialsweepTracePoints];      //开辟空间存储GetPartial的频率数据。
	PartialTrace.PowerSpec_dBm = new float[TraceInfo.PartialsweepTracePoints]; //开辟空间存储GetPartial的功率数据。

	while (1)
	{
		for (int j = 0; j < TraceInfo.TotalHops; j++) //TraceInfo.TotalHops代表当前配置下的帧数，因此循环TraceInfo.TotalHops次调用SWP_GetPartialSweep即可得到完整迹线。
		{
			Status = SWP_GetPartialSweep_PM1(&Device, &PartialTrace);


			if (Status == APIRETVAL_NoError)
			{	
				memcpy(Frequency.data() + j * TraceInfo.PartialsweepTracePoints, PartialTrace.Freq_Hz, TraceInfo.PartialsweepTracePoints * sizeof(double));          //将频率GetPartial的数据拼接成整条迹线。
				memcpy(PowerSpec_dBm.data() + j * TraceInfo.PartialsweepTracePoints, PartialTrace.PowerSpec_dBm, TraceInfo.PartialsweepTracePoints * sizeof(float)); //将功率GetPartial的数据拼接成整条迹线。

				for (int i = 0; i < TraceInfo.SamplePoints; i++)
				{
					if (TraceInfo.DataFormat == Complex16bit)
					{
						((int16_t*)I_Data)[i] = ((int16_t*)PartialTrace.AlternIQStream)[i * 2];     //从交织的数据中，获取I路数据。
						((int16_t*)Q_Data)[i] = ((int16_t*)PartialTrace.AlternIQStream)[i * 2 + 1]; //从交织的数据中，获取Q路数据。
					}
					else
					{
						((int32_t*)I_Data)[i] = ((int32_t*)PartialTrace.AlternIQStream)[i * 2];
						((int32_t*)Q_Data)[i] = ((int32_t*)PartialTrace.AlternIQStream)[i * 2 + 1];
					}
				}
			}
		}
	}

	Device_Close(&Device); //关闭设备。

	return 0;
}