﻿#include <stdio.h>
#include <string.h>
#include <vector>
#include <chrono>
#include<iostream>
#include "example.h"
#include "htra_api.h"
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int SWP_Fixedtime_GetFrames()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo);              //打开设备。

	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。


	SWP_Profile_TypeDef SWP_ProfileIn;  //SWP输入配置，包括起始频率、终止频率、RBW、参考电平等。
	SWP_Profile_TypeDef SWP_ProfileOut; //SWP输出配置。
	SWP_TraceInfo_TypeDef TraceInfo;    //当前配置下的迹线信息，包括迹线点数、跳频点数等。

	SWP_ProfileDeInit(&Device, &SWP_ProfileIn); //初始化SWP模式的相关参数。

	SWP_ProfileIn.StartFreq_Hz = 9e3;   //配置起始频率。
	SWP_ProfileIn.StopFreq_Hz = 6.35e9; //配置终止频率。
	SWP_ProfileIn.RBW_Hz = 300e3;       //配置RBW。

	Status = SWP_Configuration(&Device, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //下发SWP模式的相关配置。

	SWP_Configuration_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	vector<double> Frequency(TraceInfo.FullsweepTracePoints);    //创建频率数组。
	vector<float> PowerSpec_dBm(TraceInfo.FullsweepTracePoints); //创建功率数组。
	int HopIndex = 0;                                            //当前跳频点索引。
	int FrameIndex = 0;                                          //当前帧索引。
	MeasAuxInfo_TypeDef MeasAuxInfo;                             //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

	int t = 0;              //循环次数计数器。
	int frame = 0;          //每次循环中的帧数。
	int frame_mul = 0;      //累计的所有帧数。
	double frame_avg = 0.0; //平均帧数。
	double time = 10.0;     //每次循环的时间限制（秒）。

	// 初始化设备和变量等。
	// Device Device。
	// 等其他变量和函数初始化。

	auto start = std::chrono::high_resolution_clock::now();  //外部循环的开始时间。
	
	 // 循环5次。
	while (t < 5) { 
	
		frame = 0; //重置帧数。

		//在达到时间限制之前持续调用 SWP_GetPartialSweep。
		auto loop_start = std::chrono::high_resolution_clock::now(); //内部循环的开始时间。
		auto stop = loop_start;
		auto timeout = std::chrono::duration_cast<std::chrono::duration<double, std::ratio<1, 1>>>(stop - start);

		while (timeout.count() < time) 
		{
			Status = SWP_GetPartialSweep(&Device, Frequency.data(), PowerSpec_dBm.data(), &HopIndex, &FrameIndex, &MeasAuxInfo); //获取频谱数据。

			SWP_ErrorHandlingExceptOpenAndConfiguration(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理
			
			stop = std::chrono::high_resolution_clock::now();
			timeout = std::chrono::duration_cast<std::chrono::duration<double, std::ratio<1, 1>>>(stop - loop_start);

			frame++; //累计频谱帧数。

		}

		//输出当前循环内的结果。
		cout << "In the " << t + 1 << "th loop, the number of spectrum frames that can be obtained within " << timeout.count() << " seconds is: " << frame << endl;
		frame_mul += frame;  //累加所有循环的频谱帧数。
		t++;  //增加循环计数。

		//重新开始计时。
		start = std::chrono::high_resolution_clock::now();
	}

	//计算并输出平均帧数。
	frame_avg = static_cast<double>(frame_mul) / t;
	cout << "The average number of spectrum frames that can be obtained within 10 seconds（5 times）: " << frame_avg << endl;
	Device_Close(&Device); //关闭设备。

	return 0;
}