﻿#include <stdio.h>
#include <iostream>
#include <string.h>
#include <vector>
#include "example.h"
#include "htra_api.h"
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int SWP_EZGetPartialSweep()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo);              //打开设备。

	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	SWP_EZProfile_TypeDef SWP_EZProfileIn;  //SWP输入配置，包括起始频率、终止频率、RBW、参考电平等等。
	SWP_EZProfile_TypeDef SWP_EZProfileOut; //SWP输出配置。
	SWP_TraceInfo_TypeDef TraceInfo;        //当前配置下的迹线信息，包括迹线点数、跳频点数等。

	SWP_EZProfileDeInit(&Device, &SWP_EZProfileIn); //初始化SWP模式的相关参数。

	SWP_EZProfileIn.StartFreq_Hz = 9e3;   //配置起始频率。
	SWP_EZProfileIn.StopFreq_Hz = 6.35e9; //配置终止频率。
	SWP_EZProfileIn.RBW_Hz = 300e3;       //配置RBW。

	Status = SWP_EZConfiguration(&Device, &SWP_EZProfileIn, &SWP_EZProfileOut, &TraceInfo); //下发SWP模式的相关配置。
	if (Status == APIRETVAL_NoError)
	{
		cout << " Configuration successfully applied " << endl;
	}

	/*设备打开失败，返回错误提示，发生以下错误时，设备无法正常运行，建议按照提示操作后重新打开设备*/
	else
	{

		switch (Status)
		{
			case APIRETVAL_ERROR_BusOpenFailed:printf("Error - Check device power supply, data cable connection, and ensure that the driver is installed correctly\n");break;
			case APIRETVAL_ERROR_RFACalFileIsMissing:printf("Error - RF calibration file is missing, please copy the RF calibration file to the CalFile folder\n");break;
			case APIRETVAL_ERROR_IFACalFileIsMissing:printf("Error - IF calibration file is missing, please copy the IF calibration file to the CalFile folder\n");break;
			case APIRETVAL_ERROR_DeviceConfigFileIsMissing:printf("Error - Configuration file is missing, please copy the configuration file to the CalFile folder\n");break;
			case APIRETVAL_ERROR_DeviceSpecFileIsMissing:printf("Error - Device specification file is missing, please copy the device specification file to the CalFile folder\n");break;
			default:printf("Other error returned, Status = %d\n", Status);break;
		}

		return Status;
	}
	
	vector<double> Frequency(TraceInfo.FullsweepTracePoints);    //创建频率数组。
	vector<float> PowerSpec_dBm(TraceInfo.FullsweepTracePoints); //创建功率数组。
	int HopIndex = 0;                                            //当前跳频点索引。
	int FrameIndex = 0;                                          //当前帧索引。
	MeasAuxInfo_TypeDef MeasAuxInfo;                             //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

	//循环获取频谱数据。
	while (1)
	{
		for (int i = 0; i < TraceInfo.TotalHops; i++) //TraceInfo.TotalHops代表当前配置下的帧数，因此循环TraceInfo.TotalHops次调用SWP_GetPartialSweep即可得到完整迹线。
		{
			Status = SWP_GetPartialSweep(&Device, Frequency.data() + i * TraceInfo.PartialsweepTracePoints, PowerSpec_dBm.data() + i * TraceInfo.PartialsweepTracePoints, &HopIndex, &FrameIndex, &MeasAuxInfo); //获取频谱数据。

			if (Status == APIRETVAL_NoError)
			{
				// UserCode here
				/*

				例如：显示频谱 或 对频谱做其他处理等

				*/

			}

			/*获取数据失败时，返回错误提示，发生以下错误时，建议按照提示进行操作*/
			else
			{
				switch (Status)
				{
				  case APIRETVAL_WARNING_IFOverflow:printf("Warning - IF saturation, it is recommended to reconfigure. Reference level <= signal power.\n"); break; //SWP_GetPartialSweep如果返回值为-12，建议重新配置参数获取。
				  case APIRETVAL_WARNING_ReconfigurationIsRecommended:printf("Warning - The temperature variation of the current device is large. It is recommended to reconfigure the temperature.\n"); break; //SWP_GetPartialSweep如果返回值为-14，建议重新配置参数后再获取。
				  default:printf("Return other errors: Status = %d\n", Status); Device_Close(&Device); break;
				}
			}
		}
	}

	Device_Close(&Device); //关闭设备。

	return 0;
}