﻿#include <stdio.h>
#include <string.h>
#include <vector>
#include <chrono>
#include "example.h"
#include "htra_api.h"

using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int RTAMode_Standard_perframe()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。

	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	RTA_Profile_TypeDef RTA_ProfileIn;  //RTA输入配置，包括中心频率、抽取倍数、参考电平等。
	RTA_Profile_TypeDef RTA_ProfileOut; //RTA输出配置
	RTA_FrameInfo_TypeDef FrameInfo;    //当前配置下的RTA数据相关信息，包括起始频率、终止频率、数据点数等。

	RTA_ProfileDeInit(&Device, &RTA_ProfileIn); //初始化配置RTA模式的相关参数。

	RTA_ProfileIn.CenterFreq_Hz = 1e9;    //配置中心频率。
	RTA_ProfileIn.RefLevel_dBm = 0;       //配置参考电平。
	RTA_ProfileIn.DecimateFactor = 1;	  //配置抽取倍数。
	RTA_ProfileIn.TriggerMode = Adaptive; //配置触发模式。
	RTA_ProfileIn.TriggerSource = Bus;    //配置触发源为内部总线触发。
	RTA_ProfileIn.TriggerAcqTime = 0.1;   //配置触发后的采样时间为0.1s，仅在FixedPoints模式下生效。

	Status = RTA_Configuration(&Device, &RTA_ProfileIn, &RTA_ProfileOut, &FrameInfo); //下发RTA模式的相关配置。

	RTA_Configuration_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo, &RTA_ProfileIn, &RTA_ProfileOut, &FrameInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	vector<uint8_t> SpectrumTrace(FrameInfo.PacketValidPoints);                    //创建频谱数组。
	vector<uint16_t> SpectrumBitmap(FrameInfo.FrameHeight * FrameInfo.FrameWidth); //创建频谱位图数组。
	vector<float> Spectrum(FrameInfo.FrameWidth);                                  //创建dBm单位的频谱数组。
	RTA_PlotInfo_TypeDef RTA_PlotInfo;                                             //绘图信息。
	RTA_TriggerInfo_TypeDef TriggerInfo;                                           //触发信息。
	MeasAuxInfo_TypeDef MeasAuxInfo;                                               //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

	bool tag = false;		 //当RTA_ProfileOut.TriggerMode = Adaptive时，获取数据之前控制触发1次。
	float time_multiple = 0; //多次获取数据所需总时间。
	float time_avg = 0;		 //获取每帧数据的平均时间。
	int t = 0;				 //控制while循环次数。

	while (t<1000)
	{
		if (RTA_ProfileOut.TriggerMode == Adaptive && tag != true)
		{
			Status = RTA_BusTriggerStart(&Device); //触发设备。若触发源为外部触发，则不需要调用此函数。
			tag = true;
		}
		if (RTA_ProfileOut.TriggerMode == FixedPoints)
		{
			Status = RTA_BusTriggerStart(&Device); //触发设备。若触发源为外部触发，则不需要调用此函数。
		}
		for (uint32_t i = 0; i < FrameInfo.PacketCount; i++)
		{
			auto start = std::chrono::high_resolution_clock::now();

			Status = RTA_GetRealTimeSpectrum(&Device, SpectrumTrace.data(), SpectrumBitmap.data(), &RTA_PlotInfo, &TriggerInfo, &MeasAuxInfo); //获取RTA数据及触发信息。
			if (Status == 0)
			{
				auto stop = std::chrono::high_resolution_clock::now();
				auto timeout = std::chrono::duration_cast<std::chrono::duration<double, ratio<1, 1000>>>(stop - start);
				time_multiple += timeout.count();
		
				// UserCode here
				/*

				//将RTA频谱数据的单位转换成dBm
				for (int i = 0; i < FrameInfo.FrameWidth; i++)
				{
					Spectrum[i] = (float)SpectrumTrace[i] * RTA_PlotInfo.ScaleTodBm + RTA_PlotInfo.OffsetTodBm;
				}

				*/
			}

			else //当Status不为0时，根据Status的返回值进行相对应的错误处理。
			{

				RTA_ErrorHandlingExceptOpenAndConfiguration(Status, &Device, DevNum, &BootProfile, &BootInfo, &RTA_ProfileIn, &RTA_ProfileOut, &FrameInfo);

			}
		}
		t++;	
	}

	time_avg = time_multiple / (FrameInfo.PacketCount * 1000); //计算获取每帧数据的时间。
	printf("The time taken to obtain a frame of data is as follows：%lf ms", time_avg);

	Status = RTA_BusTriggerStop(&Device); //停止触发设备。若触发源为外部触发，则不需要调用此函数。

	Device_Close(&Device); //关闭设备。

	return 0;
}
