﻿#include <iostream>
#include <vector>
#include <string>
#include <map>
#include "htra_api.h"
#include "example.h"
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int Device_SysPowerState()
{
	map<uint16_t, string> SysPowerStateToState; //SysPowerState映射状态。
	SysPowerStateToState[0x00] = "PowerON";		//系统所有工作区均上电。
	SysPowerStateToState[0x01] = "RFPowerOFF";  //射频下电状态，不可快速唤醒。
	SysPowerStateToState[0x02] = "RFStandby";   //待机状态，可快速唤醒。

	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置。
	BootInfo_TypeDef BootInfo;       //启动信息。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。

	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理

	SysPowerState_TypeDef SysPowerState;

	SysPowerState = PowerON; 
	Status = Device_SetSysPowerState(&Device, SysPowerState); //设置设备状态。
	cout << "SysPowerState: " << SysPowerStateToState[SysPowerState] << endl;

	/*
	此处填写客户代码（初始化等，配置）
	例如：获取迹线，频谱显示等。

	在执行完程序之后若想让设备处于低功耗状态可以将射频处于下电状态。（具体代码如下）
	*/

	SysPowerState = RFPowerOFF;                               //射频处于下电状态，不可快速唤醒。
	Status = Device_SetSysPowerState(&Device, SysPowerState); //设置设备状态。
	cout << "SysPowerState: " << SysPowerStateToState[SysPowerState] << endl;

	Device_Close(&Device); //关闭设备。
	return 0;
}