﻿#include <stdio.h>
#include <string.h>
#include <vector>
#include <iostream>
#include "htra_api.h"
#include "example.h"
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int DETMode_Standard()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。

	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	DET_Profile_TypeDef DET_ProfileIn;  //DET输入配置，包括中心频率、抽取倍数、参考电平等等。
	DET_Profile_TypeDef DET_ProfileOut; //DET输出配置。
	DET_StreamInfo_TypeDef StreamInfo;  //当前配置下的DET数据相关信息，包括DET数据点数、字节数等。

	DET_ProfileDeInit(&Device, &DET_ProfileIn); //初始化配置DET模式的相关参数。

	DET_ProfileIn.CenterFreq_Hz = 1e9;    //配置中心频率。
	DET_ProfileIn.RefLevel_dBm = 0;       //配置参考电平。
	DET_ProfileIn.DecimateFactor = 2;	  //配置抽取倍数。
	DET_ProfileIn.TriggerMode = Adaptive; //配置触发模式。
	DET_ProfileIn.TriggerSource = Bus;    //配置触发源为内部总线触发。
	DET_ProfileIn.TriggerLength = 16242;  //配置单次触发采集的点数。仅在FixedPoints模式下生效。

	Status = DET_Configuration(&Device, &DET_ProfileIn, &DET_ProfileOut, &StreamInfo); //下发DET模式的相关配置。

	DET_Configuration_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo, &DET_ProfileIn, &DET_ProfileOut, &StreamInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	vector<float> NormalizedPowerStream(StreamInfo.PacketSamples); //创建功率数组。
	float ScaleToV = 0;                                            //此参数为绝对幅度（V单位）的比例因子。
	DET_TriggerInfo_TypeDef TriggerInfo;                           //触发信息。
	MeasAuxInfo_TypeDef MeasAuxInfo;                               //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

	bool tag = false; //当RTA_ProfileOut.TriggerMode = Adaptive时，获取数据之前控制触发1次。

	while (1)
	{
		if (DET_ProfileOut.TriggerMode == Adaptive && tag != true)	   //当RTA_EZProfileOut.TriggerMode = Adaptive时仅触发一次。
		{
			Status = DET_BusTriggerStart(&Device);                     //调用RTA_BusTriggerStart触发设备。若触发源为外部触发，则不需要调用此函数。
			tag = true;
		}
		if (DET_ProfileOut.TriggerMode == FixedPoints)                 //当RTA_EZProfileOut.TriggerMode = FixedPoints时每次循环均触发。
		{
			Status = DET_BusTriggerStart(&Device);                     //调用RTA_BusTriggerStart触发设备。若触发源为外部触发，则不需要调用此函数。
		}
		for (uint32_t i = 0; i < StreamInfo.PacketCount; i++)		   //仅TriggerMode为FixedPoints时生效，当TriggerMode为Adaptive不生效，此时StreamInfo.PacketCount为1。
		{
			Status = DET_GetPowerStream(&Device, NormalizedPowerStream.data(), &ScaleToV, &TriggerInfo, &MeasAuxInfo); //获取DET数据及触发信息。

			if (Status == APIRETVAL_NoError)
			{
				// UserCode here
				/*

				//将DET数据的单位转换成dBm
				for (int i = 0; i < StreamInfo.PacketSamples; i++)
				{
					NormalizedPowerStream[i] = 10 * log10(20 * pow(NormalizedPowerStream[i] * ScaleToV, 2));
				}

				*/
			}

			else //当Status不为0时，根据Status的返回值进行相对应的错误处理。
			{
				DET_ErrorHandlingExceptOpenAndConfiguration(Status, &Device, DevNum, &BootProfile, &BootInfo, &DET_ProfileIn, &DET_ProfileOut, &StreamInfo);
			}
		}
	}

	Status = DET_BusTriggerStop(&Device); //停止触发设备。若触发源为外部触发，则不需要调用此函数。

	Device_Close(&Device); //关闭设备。

	return 0;
}