#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDebug>

#include <htra_api.h>
#include <stdio.h>
#include <string.h>
#include <vector>

using namespace std;

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    int Status = 0;                  //函数的返回值，返回值表示当前的错误代码：错误代码=0表示无错误，其他错误的代码的详细信息请查看htra_api.h文件最下方的错误代码对照表 或 查看API指南中的附录1。
    void* Device = NULL;             //此参数为频谱仪存储频谱仪设备信息的内存地址，调用此函数后，函数将返回当前打开的设备内存地址。后续在调用其他API时，必须通过此地址参数来索引此次打开的设备。
    int DevNum = 0;                  //指定设备号，当主机连接有多台设备时，可通过此设备号来选择相应的设备，设备号从0开始累加。

    BootProfile_TypeDef BootProfile; //启动配置结构体，用于配置与设备启动相关参数。
    BootInfo_TypeDef BootInfo;       //反馈启动配置信息结构体，告知用户当前设备的设备号、固件版本等信息。

    BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。
    //注意：根据您手中的设备接口类型选择USB或者网口
    //设备接口为USB则直接运行，设备接口为网口则将下面的USB相关代码注释，并取消网口相关代码的注释

    //数据接口为USB的设备
    BootProfile.PhysicalInterface = USB;				 //使用USB接口进行数据传输。

    //数据接口为网口的的设备
    //BootProfile.PhysicalInterface = ETH; //使用网口进行数据传输。
    //BootProfile.ETH_IPVersion = IPv4;    //网际协议使用IPv4。
    //BootProfile.ETH_RemotePort = 5000;   //端口号固定为5000。
    //BootProfile.ETH_ReadTimeOut = 10000; //配置网口读取超时时间ms。
    //BootProfile.ETH_IPAddress[0] = 192;  //配置NX的IP地址，NX设备默认IP地址为192.168.1.100。
    //BootProfile.ETH_IPAddress[1] = 168;
    //BootProfile.ETH_IPAddress[2] = 1;
    //BootProfile.ETH_IPAddress[3] = 100;

    Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。
    if (Status == APIRETVAL_NoError) {
        qDebug() << __FUNCTION__ << __LINE__ << "Device opened successful!";
    } else {
        qDebug() << __FUNCTION__ << __LINE__ << "Device failed to open!";
        qDebug() << __FUNCTION__ << __LINE__ << "Status = " << Status;
    }

    DeviceInfo_TypeDef DeviceInfo;                         //存放设备信息的结构体，包括设备UID、设备型号、固件版本等等。
    Status = Device_QueryDeviceInfo(&Device, &DeviceInfo); //获取设备信息，包括设备UID、设备型号、固件版本等等。

    SWP_Profile_TypeDef SWP_ProfileIn;                    //此结构体用于配置需要下发的SWP模式参数，包括起始频率、终止频率、RBW、参考电平等等。
    SWP_Profile_TypeDef SWP_ProfileOut;                   //此结构体用于反馈实际下发的SWP模式参数，包括起始频率、终止频率、RBW、参考电平等等。
    SWP_TraceInfo_TypeDef TraceInfo;                      //此结构体用于反馈当前配置下的迹线信息，包括迹线点数、调频点数等等。

    SWP_ProfileDeInit(&Device, &SWP_ProfileIn);           //调用此函数初始化配置SWP模式的相关参数。

    SWP_ProfileIn.StartFreq_Hz = 9e3;                    //配置起始频率。
    SWP_ProfileIn.StopFreq_Hz = 40.02e9;                 //配置终止频率。
    SWP_ProfileIn.RBW_Hz = 300e3;                        //配置RBW。

    Status = SWP_Configuration(&Device, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //通过调用此函数下发SWP模式的相关配置。
    if (Status == APIRETVAL_NoError) {
        qDebug() << __FUNCTION__ << __LINE__ << "Configuration successful!";
    } else {
        qDebug() << __FUNCTION__ << __LINE__ << "Configuration failure!";
        qDebug() << __FUNCTION__ << __LINE__ << "Status = " << Status;
    }

    DeviceState_TypeDef DeviceState;                                  //存放设备状态的结构体，包括设备温度、设备射频状态等等。
    Status = Device_QueryDeviceState_Realtime(&Device, &DeviceState); //获取设备状态，包括设备温度、设备射频状态等等。

    vector<double> Frequency(TraceInfo.FullsweepTracePoints);         //动态建立数组，存放整条频率数据。
    vector<float> PowerSpec_dBm(TraceInfo.FullsweepTracePoints);      //动态建立数组，存放整条幅度数据。
    int HopIndex = 0;                                                 //此设备的一整段频谱是由拼帧的方式得到的，该参数用于返回当前帧序号。
    int FrameIndex = 0;                                               //表示当前帧在所有帧中的索引。
    MeasAuxInfo_TypeDef MeasAuxInfo;                                  //此结构体用于存放测量数据的辅助信息。

    while (1)
    {
        for (int i = 0; i < TraceInfo.TotalHops; i++)                //TraceInfo.TotalHops代表当前配置下的帧数，因此循环TraceInfo.TotalHops次调用SWP_GetPartialSweep即可得到完整迹线。
        {
            Status = SWP_GetPartialSweep(&Device, Frequency.data() + i * TraceInfo.PartialsweepTracePoints, PowerSpec_dBm.data() + i * TraceInfo.PartialsweepTracePoints, &HopIndex, &FrameIndex, &MeasAuxInfo); //获取频谱数据。
            if (Status == APIRETVAL_NoError) {
                //UserCode here
                //例如：显示频谱 或 对频谱做其他处理等


            } else {
                qDebug() << __FUNCTION__ << __LINE__ << "Status = " << Status;
            }
        }
        qDebug() << __FUNCTION__ << __LINE__ << "Frequency[0] = " << Frequency[0] << "; " << "PowerSpec_dBm[0] = " << PowerSpec_dBm[0];
    }

    Device_Close(&Device); //关闭设备。
}

MainWindow::~MainWindow()
{
    delete ui;
}

