﻿#include<chrono>
#include <stdio.h>
#include <string.h>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <vector>
#include "example.h"
#include "htra_api.h" 
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int SWP_SetFreqCompensation()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。

	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	SWP_Profile_TypeDef SWP_ProfileIn;  //SWP输入配置，包括起始频率、终止频率、RBW、参考电平等。
	SWP_Profile_TypeDef SWP_ProfileOut; //SWP输出配置。
	SWP_TraceInfo_TypeDef TraceInfo;    //当前配置下的迹线信息，包括迹线点数、跳频点数等。

	SWP_ProfileDeInit(&Device, &SWP_ProfileIn); //初始化SWP模式的相关参数。

	SWP_ProfileIn.StartFreq_Hz = 9e3;   //配置起始频率。
	SWP_ProfileIn.StopFreq_Hz = 6.35e9; //配置终止频率。
	SWP_ProfileIn.RBW_Hz = 300e3;       //配置RBW。

	Status = SWP_Configuration(&Device, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //下发SWP模式的相关配置。

	SWP_Configuration_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	vector<double> Frequency(TraceInfo.FullsweepTracePoints);     //创建频率数组。
	vector<float> PowerSpec_dBm(TraceInfo.FullsweepTracePoints);  //创建功率数组。
	vector<float> Compensate_dBm(TraceInfo.FullsweepTracePoints); //创建功率补偿数据数组。

	//由于Devcie_SetFreqResponseCompensation（）的参数Points为uint8_t，所以此参数最大为256。
	for (int i = 0; i < 256; i++) 
	{
		//设置补偿值为30dBm。
		Compensate_dBm[i] = 30;
	}

	Status = Devcie_SetFreqResponseCompensation(&Device, 1, Frequency.data(), Compensate_dBm.data(), TraceInfo.FullsweepTracePoints);

	MeasAuxInfo_TypeDef MeasAuxInfo; //此结构体用于存放测量数据的辅助信息。

	while (1) 
	{
		//获取频谱数据。
		Status = SWP_GetFullSweep(&Device, Frequency.data(), PowerSpec_dBm.data(), &MeasAuxInfo);

		if (Status == APIRETVAL_NoError)
		{
			// UserCode here
			/*

			例如：显示频谱 或 对频谱做其他处理等

			*/
		}

		else //当Status不为0时，根据Status的返回值进行相对应的错误处理。
		{
			SWP_ErrorHandlingExceptOpenAndConfiguration(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo);
		}
	}

	Device_Close(&Device); //关闭设备。

	return 0;
}