﻿#include <stdio.h>
#include <string.h>
#include <vector>
#include <iostream>
#include "htra_api.h"
#include "example.h"

using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int RTAMode_EZStandard()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。

	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理

	RTA_EZProfile_TypeDef RTA_EZProfileIn;  //RTA输入配置，包括中心频率、抽取倍数、参考电平等。 
	RTA_EZProfile_TypeDef RTA_EZProfileOut; //RTA输出配置。
	RTA_FrameInfo_TypeDef FrameInfo;        //当前配置下的RTA数据相关信息，包括起始频率、终止频率、数据点数等。

	RTA_EZProfileDeInit(&Device, &RTA_EZProfileIn); //初始化配置RTA模式的相关参数。

	RTA_EZProfileIn.CenterFreq_Hz = 1e9;    //配置中心频率。
	RTA_EZProfileIn.RefLevel_dBm = 0;       //配置参考电平。
	RTA_EZProfileIn.DecimateFactor = 1;	    //配置抽取倍数。
	RTA_EZProfileIn.TriggerMode = Adaptive; //配置触发模式。
	RTA_EZProfileIn.TriggerSource = Bus;    //配置触发源为内部总线触发。
	RTA_EZProfileIn.TriggerAcqTime = 0.1;   //配置触发后的采样时间为0.1s，仅在FixedPoints模式下生效。

	Status = RTA_EZConfiguration(&Device, &RTA_EZProfileIn, &RTA_EZProfileOut, &FrameInfo); //下发RTA模式的相关配置。

	if (Status == 0)
	{
		cout << "Configuration applied successfully!" << endl;
	}
	else
	{
		cout << "Error in RTA_EZConfiguration call. Status = " << Status << endl;
		Device_Close(&Device);
		return 0;
	}

	vector<uint8_t> SpectrumTrace(FrameInfo.PacketValidPoints);                    //创建频谱数组。
	vector<uint16_t> SpectrumBitmap(FrameInfo.FrameHeight * FrameInfo.FrameWidth); //创建频谱位图数组。
	vector<float> Spectrum(FrameInfo.FrameWidth);                                  //创建dBm单位的频谱数组。
	RTA_PlotInfo_TypeDef RTA_PlotInfo;                                             //绘图信息。
	RTA_TriggerInfo_TypeDef TriggerInfo;                                           //触发信息。
	MeasAuxInfo_TypeDef MeasAuxInfo;                                               //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

	bool tag = false; //当RTA_ProfileOut.TriggerMode = Adaptive时，获取数据之前控制触发1次。

	while (1)
	{
		if (RTA_EZProfileOut.TriggerMode == Adaptive && tag != true) //当RTA_EZProfileOut.TriggerMode = Adaptive时仅触发一次。
		{
			Status = RTA_BusTriggerStart(&Device);                   //调用RTA_BusTriggerStart触发设备。若触发源为外部触发，则不需要调用此函数。
			tag = true;
		}
		if (RTA_EZProfileOut.TriggerMode == FixedPoints)             //当RTA_EZProfileOut.TriggerMode = FixedPoints时每次循环均触发。
		{
			Status = RTA_BusTriggerStart(&Device);                   //调用RTA_BusTriggerStart触发设备。若触发源为外部触发，则不需要调用此函数。
		}
		for (uint32_t i = 0; i < FrameInfo.PacketCount; i++)	     //仅TriggerMode为FixedPoints时生效，当TriggerMode为Adaptive不生效，此时StreamInfo.PacketCount为1。
		{
			Status = RTA_GetRealTimeSpectrum(&Device, SpectrumTrace.data(), SpectrumBitmap.data(), &RTA_PlotInfo, &TriggerInfo, &MeasAuxInfo); //获取RTA数据及触发信息。
			if (Status == 0)
			{
				// UserCode here
				/*

				//将RTA频谱数据的单位转换成dBm
				for (int i = 0; i < FrameInfo.FrameWidth; i++)
				{
					Spectrum[i] = (float)SpectrumTrace[i] * RTA_PlotInfo.ScaleTodBm + RTA_PlotInfo.OffsetTodBm;
				}

				*/
			}
			else
			{
				switch (Status)
				{
				case APIRETVAL_WARNING_IFOverflow:
					std::cout << "Warning - IF saturation detected. Reconfiguration recommended. Reference level <= signal power." << std::endl;
					break;
				case APIRETVAL_WARNING_ReconfigurationIsRecommended:
					std::cout << "Warning - Significant temperature change detected on the device. Reconfiguration of temperature is recommended." << std::endl;
					break;
			    default:
					std::cout << "Other error returned. Status = " << Status << std::endl;
					Device_Close(&Device);
					break;
				}
			}
		}
	}

	Status = RTA_BusTriggerStop(&Device); //停止触发设备。若触发源为外部触发，则不需要调用此函数。

	Device_Close(&Device); //关闭设备。

	return 0;
}
