from htra_api import *
from ctypes import pointer

###打开设备###
Status = 0          #函数的返回。
Device = c_void_p() #当前设备的内存地址。
DevNum = c_int(0)   #指定设备号。

BootProfile = BootProfile_TypeDef() #启动配置结构体，包括物理接口、供电方式等。
BootInfo = BootInfo_TypeDef()       #启动信息结构体，包括设备信息、USB速率等。

BootProfile.DevicePowerSupply = DevicePowerSupply_TypeDef.USBPortAndPowerPort #使用USB数据端口及独立电源端口双供电
BootProfile.PhysicalInterface = PhysicalInterface_TypeDef.USB                 #使用USB接口进行数据传输。

#使用网口设备配置ETH接口
#BootProfile.PhysicalInterface = PhysicalInterface_TypeDef.ETH #使用网口进行数据传输
#BootProfile.ETH_IPVersion = IPVersion_TypeDef.IPv4
#BootProfile.ETH_RemotePort = 5000
#BootProfile.ETH_ReadTimeOut = 10000
#BootProfile.ETH_IPAddress[0] = 192
#BootProfile.ETH_IPAddress[1] = 168
#BootProfile.ETH_IPAddress[2] = 1
#BootProfile.ETH_IPAddress[3] = 100

Status = dll.Device_Open(pointer(Device),DevNum,pointer(BootProfile),pointer(BootInfo)) #打开设备。
if(Status == 0):
    print("Device is opened successfully")
else:
    print("Return other errors Status = {:d}".format(Status))

###配置下发###
SWP_ProfileIn = SWP_Profile_TypeDef()  #SWP输入配置，包括起始频率、终止频率、RBW、参考电平等。
SWP_ProfileOut = SWP_Profile_TypeDef() #SWP输出配置。
TraceInfo = SWP_TraceInfo_TypeDef()    #当前配置下的迹线信息，包括迹线点数、跳频点数等。

dll.SWP_ProfileDeInit(pointer(Device),pointer(SWP_ProfileIn)) #初始化SWP模式的相关参数。

SWP_ProfileIn.StartFreq_Hz = 1e9                        #配置起始频率。
SWP_ProfileIn.StopFreq_Hz = 2e9                         #配置终止频率。
SWP_ProfileIn.RBW_Hz=50e3                               #配置RBW。
SWP_ProfileIn.RBWMode = RBWMode_TypeDef.RBW_Manual      #配置RBW配置模式。
SWP_ProfileIn.VBWMode = VBWMode_TypeDef.VBW_TenTimesRBW #配置VBW。
SWP_ProfileIn.FreqAssignment = SWP_FreqAssignment_TypeDef.StartStop

Status = dll.SWP_Configuration(pointer(Device),pointer(SWP_ProfileIn),pointer(SWP_ProfileOut),pointer(TraceInfo))   #下发SWP模式的相关配置。

if(Status == 0):
    print("configuration delievery succeeded")
else:
    print("SWP_Configuration call is incorrect Status = {:d}".format(Status))

###获取数据###
Frequency = (c_double * TraceInfo.FullsweepTracePoints)()      #创建频率数组。
PowerSpec_dBm = (c_float * TraceInfo.FullsweepTracePoints)()   #创建功率数组。
PartialFreq = (c_double * TraceInfo.PartialsweepTracePoints)() #单帧频率数组。
PartialSpec = (c_float * TraceInfo.PartialsweepTracePoints)()  #单帧功率数组。
HopIndex = c_int(0)                                            #当前跳频点索引。
FrameIndex = c_int(0)                                          #当前帧索引。
MeasAuxInfo = MeasAuxInfo_TypeDef()                            #此结构体用于存放测量数据的辅助信息

# 尝试导入绘图模块pyplot，绘制SWP模式频谱图
try:
    from plot_module import start_plot
    update_plot = start_plot(Sup_title="Standard Spectrum", Subplot1_X=Frequency, Subplot1_Y=PowerSpec_dBm, xlabel1="Frequency(Hz)", ylabel1="Spectrum(dBm)", title1=None)

except ImportError:
    print("matplotlib.pyplot not available. Plotting disabled.")
    update_plot = None
    start_plot = None


try:
    while(True):
        for i in range(0,TraceInfo.TotalHops):
            Status = dll.SWP_GetPartialSweep(pointer(Device),PartialFreq,PartialSpec, pointer(HopIndex), pointer(FrameIndex),pointer(MeasAuxInfo))
            Frequency[i*TraceInfo.PartialsweepTracePoints:(i+1)*TraceInfo.PartialsweepTracePoints] = PartialFreq
            PowerSpec_dBm[i*TraceInfo.PartialsweepTracePoints:(i+1)*TraceInfo.PartialsweepTracePoints] = PartialSpec

        if update_plot and not update_plot():  # 绘制频谱图
            break

except KeyboardInterrupt:
    print("Stopped by user with Ctrl+C")
finally:
    dll.Device_Close(pointer(Device))
    print("Device closed.")


