from htra_api import *
import matplotlib.pyplot as plt

###打开设备###
Status = 0          #函数的返回。
Device = c_void_p() #当前设备的内存地址。
DevNum = c_int(0)   #指定设备号。

BootProfile = BootProfile_TypeDef() #启动配置结构体，包括物理接口、供电方式等。
BootInfo = BootInfo_TypeDef()       #启动信息结构体，包括设备信息、USB速率等。

BootProfile.DevicePowerSupply = DevicePowerSupply_TypeDef.USBPortAndPowerPort #使用USB数据端口及独立电源端口双供电
BootProfile.PhysicalInterface = PhysicalInterface_TypeDef.USB                 #使用USB接口进行数据传输。

#使用网口设备配置ETH接口
#BootProfile.PhysicalInterface = PhysicalInterface_TypeDef.ETH #使用网口进行数据传输
#BootProfile.ETH_IPVersion = IPVersion_TypeDef.IPv4
#BootProfile.ETH_RemotePort = 5000
#BootProfile.ETH_ReadTimeOut = 10000
#BootProfile.ETH_IPAddress[0] = 192
#BootProfile.ETH_IPAddress[1] = 168
#BootProfile.ETH_IPAddress[2] = 1
#BootProfile.ETH_IPAddress[3] = 100

Status = dll.Device_Open(pointer(Device),DevNum,pointer(BootProfile),pointer(BootInfo)) #打开设备。
if(Status == 0):
    print("Device is opened successfully")
else:
    print("Return other errors Status = {:d}".format(Status))

###配置下发###
SWP_ProfileIn = SWP_Profile_TypeDef()  #SWP输入配置，包括起始频率、终止频率、RBW、参考电平等。
SWP_ProfileOut = SWP_Profile_TypeDef() #SWP输出配置。
TraceInfo = SWP_TraceInfo_TypeDef()    #当前配置下的迹线信息，包括迹线点数、跳频点数等。

dll.SWP_ProfileDeInit(pointer(Device),pointer(SWP_ProfileIn))   #初始化配置SWP模式的相关参数。

SWP_ProfileIn.StartFreq_Hz = 1e9 #配置起始频率。
SWP_ProfileIn.StopFreq_Hz = 2e9  #配置终止频率。

Status = dll.SWP_Configuration(pointer(Device),pointer(SWP_ProfileIn),pointer(SWP_ProfileOut),pointer(TraceInfo)) #下发SWP模式的相关配置。

if(Status == 0):
    print("configuration delievery succeeded")
else:
    print("SWP_Configuration call is incorrect Status = {:d}".format(Status))

ASG_ProfileIn = ASG_Profile_TypeDef()  #ASG输入配置，包括信号源输出模式、各模式下频率，功率等参数设置。
ASG_ProfileOut = ASG_Profile_TypeDef() #ASG输出配置。
ASG_Info = ASG_Info_TypeDef()          #当前配置下扫描点数的信息。

dll.ASG_ProfileDeInit(pointer(Device),pointer(ASG_ProfileIn)) #初始化配置ASG模式的相关参数

#单音信号
ASG_ProfileIn.CenterFreq_Hz = 1.51e9
ASG_ProfileIn.Level_dBm = -20
ASG_ProfileIn.Mode = ASG_Mode_TypeDef.ASG_FixedPoint
ASG_ProfileIn.Port = ASG_Port_TypeDef.ASG_Port_Internal

#频率扫描信号
#ASG_ProfileIn.StartFreq_Hz = 1.2e9
#ASG_ProfileIn.StopFreq_Hz = 1.4e9
#ASG_ProfileIn.StepFreq_Hz = 1e6
#ASG_ProfileIn.Level_dBm = -20
#ASG_ProfileIn.Mode = ASG_Mode_TypeDef.ASG_FrequencySweep

#功率扫描信号
#ASG_ProfileIn.CenterFreq_Hz = 1.6e9
#ASG_ProfileIn.StartLevel_dBm = -30
#ASG_ProfileIn.StopLevel_dBm = -20
#ASG_ProfileIn.Mode = ASG_Mode_TypeDef.ASG_PowerSweep

dll.ASG_Configuration(pointer(Device),pointer(ASG_ProfileIn), pointer(ASG_ProfileOut), pointer(ASG_Info))

###信号输出###
Frequency = (c_double * TraceInfo.FullsweepTracePoints)()    #创建频率数组。
PowerSpec_dBm = (c_float * TraceInfo.FullsweepTracePoints)() #创建功率数组。
MeasAuxInfo = MeasAuxInfo_TypeDef()                          #测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

try:
    while True:
        Status = dll.SWP_GetFullSweep(pointer(Device),Frequency,PowerSpec_dBm,pointer(MeasAuxInfo)) #获取迹线。
        plt.plot(Frequency, PowerSpec_dBm)                                                    #绘图。
        plt.xlabel('Frequency')
        plt.ylabel('PowerSpec_dBm')

        #显示图形
        plt.show()
except KeyboardInterrupt:
    print("Stopped by user with Ctrl+C")
finally:
    dll.Device_Close(pointer(Device))
    print("Device closed.")