from htra_api import *

ModelToDevName = {
    12: "E90 R2",
    13: "E90 R3",
    22: "E200 R2",
    23: "E200 R3",
    53: "N60 R4",
    54: "M60 R4",
    55: "N45 R4",
    56: "M80 R5",
    57: "M60 R5",
    58: "N60 R5",
    59: "N45 R5",
    94: "N400 R2V2"
}

apiVersion = dll.Get_APIVersion()
major = (apiVersion >> 16) & 0xffff
minor = (apiVersion >> 8) & 0xff
rev = apiVersion & 0xff
print("htra_api version: {}.{}.{}".format(major, minor, rev))

###打开设备###
Status = 0          #函数的返回。
Device = c_void_p() #当前设备的内存地址。
DevNum = c_int(0)   #指定设备号。

BootProfile = BootProfile_TypeDef() #启动配置结构体，包括物理接口、供电方式等。
BootInfo = BootInfo_TypeDef()       #启动信息结构体，包括设备信息、USB速率等。

BootProfile.DevicePowerSupply = DevicePowerSupply_TypeDef.USBPortAndPowerPort #使用USB数据端口及独立电源端口双供电
BootProfile.PhysicalInterface = PhysicalInterface_TypeDef.USB                 #使用USB接口进行数据传输。

#使用网口设备配置ETH接口
#BootProfile.PhysicalInterface = PhysicalInterface_TypeDef.ETH #使用网口进行数据传输
#BootProfile.ETH_IPVersion = IPVersion_TypeDef.IPv4
#BootProfile.ETH_RemotePort = 5000
#BootProfile.ETH_ReadTimeOut = 10000
#BootProfile.ETH_IPAddress[0] = 192
#BootProfile.ETH_IPAddress[1] = 168
#BootProfile.ETH_IPAddress[2] = 1
#BootProfile.ETH_IPAddress[3] = 100

Status = dll.Device_Open(pointer(Device),DevNum,pointer(BootProfile),pointer(BootInfo)) #打开设备。
print("Device_Open:{}".format(Status))

###获取信息###
DeviceInfo = DeviceInfo_TypeDef()                                        #存放设备信息的结构体，包括设备UID、设备型号、固件版本等等。
Status = dll.Device_QueryDeviceInfo(pointer(Device),pointer(DeviceInfo)) #获取设备信息，包括设备UID、设备型号、固件版本等等。

print("BusSpeed:{:d}".format(BootInfo.BusSpeed))
print("Model:{:d} {}".format(DeviceInfo.Model,ModelToDevName.get(DeviceInfo.Model, "Unknown Device")))
print("DeviceInfo.DeviceUID:{:x}".format(DeviceInfo.DeviceUID))

print("MCU Firmware:{:d}.{:d}.{:d}".format((DeviceInfo.MFWVersion>>16)&0XFFFF,(DeviceInfo.MFWVersion>>8)&0XFF,DeviceInfo.MFWVersion&0XFF))
print("FPGA Firmware:{:d}.{:d}.{:d}".format((DeviceInfo.FFWVersion>>16)&0XFFFF,(DeviceInfo.FFWVersion>>8)&0XFF,DeviceInfo.FFWVersion&0XFF))

###获取状态###
DeviceState = DeviceState_TypeDef()                                                 #存放设备状态的结构体，包括设备温度、设备射频状态等等。
Status = dll.Device_QueryDeviceState_Realtime(pointer(Device),pointer(DeviceState)) #获取设备状态，包括设备温度、设备射频状态等等。
print("Device Temperature:{}℃".format(DeviceState.Temperature/100))

###关闭设备###
Status = dll.Device_Close(pointer(Device))




