% 配置编译环境
% setenv('MW_MINGW64_LOC','D:\msys64\ucrt64');
% mex -setup C++

% 加载htra_api.dll
if not(libisloaded('htra_api.dll'))   
    try
        % 尝试加载动态链接库及其头文件
        loadlibrary('.\htra_api\htra_api.dll','.\htra_api\htra_api.h'); 
    catch ME
        %  捕获加载过程中可能出现的错误，ME 是一个 MException 对象，包含了错误的详细信息
        fprintf('Failed to load htra_api.dll or htra_api.h: %s\n', ME.message);
        
        % 结束程序，请检查此.m文件同级目录下的htra_api文件夹中是否有htra_api.dll 或 htra_api.h文件
        %若不存在这两个文件，请将随寄资料\Windows\HTRA_API\x64\htra_api中的htra_api.dll 或htra_api.h文件，拷贝至.m文件同级目录下的htra_api文件夹中。
        fprintf('The program will end, please check whether the file path and file exist.\n');
        
        return;
        % 结束当前函数或脚本的执行
    end
end

libfunctions('htra_api'); %查看API中的所有函数

% 构建目标文件夹路径
folderPath = fullfile(pwd, 'htra_api_mat');

% 检查文件夹是否存在，如果不存在，创建文件夹
if ~exist(folderPath, 'dir')
    mkdir(folderPath);  % 创建目标文件夹
end

%Create a BootProfile structure.
BootProfile = libstruct('BootProfile_TypeDef'); 
save(fullfile(folderPath,'BootProfile.mat'), 'BootProfile');

%Create the DeviceInfo structure
DeviceInfo = libstruct('DeviceInfo_TypeDef');
save(fullfile(folderPath,'DeviceInfo.mat'), 'DeviceInfo');

%创建DeviceState_TypeDef结构体
DeviceState = libstruct('DeviceState_TypeDef');
save(fullfile(folderPath,'DeviceState.mat'), 'DeviceState');

%创建BootInfo_TypeDef结构体
BootInfo = libstruct('BootInfo_TypeDef');
save(fullfile(folderPath,'BootInfo.mat'), 'BootInfo');

%创建GNSSInfo_TypeDef结构体
GNSSInfo = libstruct('GNSSInfo_TypeDef');
save(fullfile(folderPath,'GNSSInfo.mat'), 'GNSSInfo');

%创建SWP_Profile_TypeDef结构体
SWP_Profile = libstruct('SWP_Profile_TypeDef');
save(fullfile(folderPath,'SWP_Profile.mat'), 'SWP_Profile');

%创建SWP_TraceInfo_TypeDef结构体
TraceInfo = libstruct('SWP_TraceInfo_TypeDef');
save(fullfile(folderPath,'TraceInfo.mat'), 'TraceInfo');

%创建MeasAuxInfo_TypeDef结构体
MeasAuxInfo = libstruct('MeasAuxInfo_TypeDef');
save(fullfile(folderPath,'MeasAuxInfo.mat'), 'MeasAuxInfo');

%创建IQS_Profile_TypeDef结构体
IQS_Profile = libstruct('IQS_Profile_TypeDef');
save(fullfile(folderPath,'IQS_Profile.mat'), 'IQS_Profile');

%创建IQS_StreamInfo_TypeDef结构体
IQS_StreamInfo = libstruct('IQS_StreamInfo_TypeDef');
save(fullfile(folderPath,'IQS_StreamInfo.mat'), 'IQS_StreamInfo');

%创建IQStream_TypeDef结构体
IQStream = libstruct('IQStream_TypeDef');
save(fullfile(folderPath,'IQStream.mat'), 'IQStream');

%创建IQS_TriggerInfo_TypeDef结构体
TriggerInfo = libstruct('IQS_TriggerInfo_TypeDef');
save(fullfile(folderPath,'TriggerInfo.mat'), 'TriggerInfo');

%创建DET_Profile_TypeDef结构体
DET_Profile = libstruct('DET_Profile_TypeDef');
save(fullfile(folderPath,'DET_Profile.mat'), 'DET_Profile');

%创建DET_StreamInfo_TypeDef结构体
DET_StreamInfo = libstruct('DET_StreamInfo_TypeDef');
save(fullfile(folderPath,'DET_StreamInfo.mat'), 'DET_StreamInfo');

%创建RTA_Profile_TypeDef结构体
RTA_Profile = libstruct('RTA_Profile_TypeDef');
save(fullfile(folderPath,'RTA_Profile.mat'), 'RTA_Profile');

%创建RTA_FrameInfo_TypeDef结构体
RTA_FrameInfo = libstruct('RTA_FrameInfo_TypeDef');
save(fullfile(folderPath,'RTA_FrameInfo.mat'), 'RTA_FrameInfo');

%创建RTA_PlotInfo_TypeDef结构体
RTA_PlotInfo = libstruct('RTA_PlotInfo_TypeDef');
save(fullfile(folderPath,'RTA_PlotInfo.mat'), 'RTA_PlotInfo');

%创建RTA_TriggerInfo_TypeDef结构体
RTA_TriggerInfo = libstruct('IQS_TriggerInfo_TypeDef');
save(fullfile(folderPath,'RTA_TriggerInfo.mat'), 'RTA_TriggerInfo');

%创建DSP_FFT_TypeDef结构体
DSP_FFT = libstruct('DSP_FFT_TypeDef');
save(fullfile(folderPath,'DSP_FFT.mat'), 'DSP_FFT');

%创建ASG_Profile_TypeDef结构体
ASG_Profile = libstruct('ASG_Profile_TypeDef');
save(fullfile(folderPath,'ASG_Profile.mat'), 'ASG_Profile');

%创建ASG_Info_TypeDef结构体
ASG_Info = libstruct('ASG_Info_TypeDef');
save(fullfile(folderPath,'ASG_Info.mat'), 'ASG_Info');

clear all;

%卸载库文件
unloadlibrary('htra_api');   
disp('htra_api已卸载完成')






