% 配置编译环境
% setenv('MW_MINGW64_LOC','D:\msys64\ucrt64');
% mex -setup C++

filePath = fullfile(pwd, 'htra_api_mat');  

% 检查文件夹是否存在，如果不存在，创建文件夹
if ~exist(filePath, 'dir')
    run('htra_api.m');
    filePath = fullfile(pwd, 'htra_api_mat');  
end

%加载htra_api.dll
if not(libisloaded('htra_api.dll'))   
    loadlibrary('.\htra_api\htra_api.dll','.\htra_api\htra_api.h'); %.dll和.h的文件路径一定要注意
end

libfunctions('htra_api'); %查看API中的所有函数

%打开设备
Device = libpointer; %创建Device指针
DevNum = 0;
Status = 0;

load(fullfile(filePath, 'BootProfile.mat'));  % 直接加载BootProfile_TypeDef结构体
load(fullfile(filePath, 'BootInfo.mat'));  % 直接加载BootInfo_TypeDef结构体

BootProfile.DevicePowerSupply = 0;

IS_USB = 1;  % 默认为 USB 设备，如果使用网口型设备则设置为 0

if IS_USB == 1
    % 配置 USB 接口
    BootProfile.PhysicalInterface = 0;
else
    % 配置 ETH 接口
    BootProfile.PhysicalInterface = 3;
    BootProfile.ETH_IPVersion = 0;
    BootProfile.ETH_RemotePort = 5000;
    BootProfile.ETH_ReadTimeOut = 5000;
    BootProfile.ETH_IPAddress = [192, 168, 1, 100];
end

%调用Device_Open函数
Status = calllib('htra_api', 'Device_Open', Device, DevNum, BootProfile, BootInfo);

if Status == 0
    get(BootProfile);%打印BootInfo的值
    get(BootInfo);%打印BootInfo的值    
    fprintf('Device successfully\n');
else
    % 设备打开失败，根据不同的错误状态进行处理
    switch Status
        case -1
            fprintf('Error - Check the power supply of the device, the connection of the data cable, and check that the driver is installed correctly\n');
        case -3
            fprintf('Error - RF calibration file is missing, please copy the RF calibration file to the CalFile folder\n');
        case -4
            fprintf('Error - IF calibration file is missing, please copy the IF calibration file to the CalFile folder\n');
        case -5
            fprintf('Error - Profile is missing, please copy the profile to the CalFile folder\n');
        case -6
            fprintf('Error - The device spec file is missing, please copy the device spec file to the CalFile folder\n');
        otherwise
            fprintf('Device turn on failed: Returns another error Status = %d', Status);
    end

    % 返回错误状态值
    return ;
end

load(fullfile(filePath, 'SWP_Profile.mat'));  % 直接加载SWP_Profile_TypeDef结构体

%定义SWP_ProfileIn指针和SWP_ProfileOut指针
SWP_ProfileIn = SWP_Profile;
SWP_ProfileOut = SWP_Profile;

%调用SWP_ProfileIn函数
Status = calllib('htra_api', 'SWP_ProfileDeInit', Device, SWP_ProfileIn);
get(SWP_ProfileIn); %打印SWP_ProfileIn_p的值

%修改SWP_ProfileIn结构体的部分参数
SWP_ProfileIn.StartFreq_Hz = 9e3; %配置起始频率
SWP_ProfileIn.StopFreq_Hz = 3e9;  %配置终止频率
SWP_ProfileIn.RefLevel_dBm = 0;	  %配置参考电平
SWP_ProfileIn.RBWMode=0;          %配置RBWMode
SWP_ProfileIn.RBW_Hz = 300e3;     %配置RBW

load(fullfile(filePath, 'TraceInfo.mat'));   % 直接加载SWP_TraceInfo_TypeDef结构体

%调用SWP_Configuration函数
Status = calllib('htra_api', 'SWP_Configuration', Device, SWP_ProfileIn,SWP_ProfileOut,TraceInfo);

% 如果配置下发成功（Status == 0）
if Status == 0
    get(SWP_ProfileOut); %打印TraceInfo的值
    get(TraceInfo); %打印TraceInfo的值
    fprintf('Configuration successfully\n');
else
    % 如果调用出错，打印错误信息并关闭设备
    fprintf('SWP_Configuration Call error Status = %d\n', Status);
    Device_Close(Device); 
    
    % 返回 0，结束函数执行
    return;
end

%创建Frequency，存放SWP的频谱数据,创建PowerSpec_dBm，存放SWP的幅度数据
Frequency = double(1:TraceInfo.FullsweepTracePoints);
PowerSpec_dBm = single(1:TraceInfo.FullsweepTracePoints);

%把C语言类型的参数转化成Matlab类型
Frequency_p = libpointer('doublePtr',Frequency);
PowerSpec_dBm_p = libpointer('singlePtr',PowerSpec_dBm);

% 此设备的一整段频谱是通过多个帧拼接而成，该参数用于返回当前帧在拼接过程中的序号。
HopIndex = int32(0);
% 表示当前帧在所有帧中的索引，用于标识当前处理的帧在所有帧中的位置。
FrameIndex = int32(0);
% 创建指针 HopIndex_p。
HopIndex_p = libpointer('int32Ptr', HopIndex);
% 创建指针 FrameIndex_p。
FrameIndex_p = libpointer('int32Ptr', FrameIndex);

load(fullfile(filePath, 'MeasAuxInfo.mat'));  % 直接加载MeasAuxInfo_TypeDef结构体

%获取n次SWP数据
n=100; 
for t=1:n
    %TraceInfo.TotalHops代表当前配置下的帧数，因此循环TraceInfo.TotalHops次调用SWP_GetPartialSweep即可得到完整迹线
    for i=1:TraceInfo.TotalHops 
        Status = calllib('htra_api', 'SWP_GetPartialSweep', Device, Frequency_p + (i-1) * TraceInfo.PartialsweepTracePoints, PowerSpec_dBm_p + (i-1) * TraceInfo.PartialsweepTracePoints,HopIndex_p,FrameIndex_p,MeasAuxInfo);     
        if Status ~= 0
           % 如果调用出错，打印错误信息并关闭设备
           fprintf('SWP_GetPartialSweep Call error Status = %d\n', Status);
           % 返回 0，结束函数执行
           return;
        end
    end
    
    %画出SWP的频谱图
    plot(Frequency_p.Value,PowerSpec_dBm_p.Value);
    ylim([-130, SWP_ProfileOut.RefLevel_dBm]);
    xlim([min(Frequency_p.Value), max(Frequency_p.Value)]);
    pause(0.01);
end

%调用Device_Close函数
Status = calllib('htra_api', 'Device_Close', Device);

clear all;

%卸载库文件
unloadlibrary('htra_api');   
disp('Uninstall complete');






