% 配置编译环境
% setenv('MW_MINGW64_LOC','D:\msys64\ucrt64');
% mex -setup C++

filePath = fullfile(pwd, 'htra_api_mat');  

% 检查文件夹是否存在，如果不存在，创建文件夹
if ~exist(filePath, 'dir')
    run('htra_api.m');
    filePath = fullfile(pwd, 'htra_api_mat');  
end

%加载htra_api.dll
if not(libisloaded('htra_api.dll'))   
    loadlibrary('.\htra_api\htra_api.dll','.\htra_api\htra_api.h'); %.dll和.h的文件路径一定要注意
end

libfunctions('htra_api'); %查看API中的所有函数

%打开设备
Device = libpointer; %创建Device指针
DevNum = 0;
Status = 0;

load(fullfile(filePath, 'BootProfile.mat'));  % 直接加载BootProfile_TypeDef结构体
load(fullfile(filePath, 'BootInfo.mat'));  % 直接加载BootInfo_TypeDef结构体

IS_USB = 1;  % 默认为 USB 设备，如果使用网口型设备则设置为 0

if IS_USB == 1
    % 配置 USB 接口
    BootProfile.PhysicalInterface = 0;
else
    % 配置 ETH 接口
    BootProfile.PhysicalInterface = 3;
    BootProfile.ETH_IPVersion = 0;
    BootProfile.ETH_RemotePort = 5000;
    BootProfile.ETH_ReadTimeOut = 5000;
    BootProfile.ETH_IPAddress = [192, 168, 1, 100];
end

%调用Device_Open函数
Status = calllib('htra_api', 'Device_Open', Device, DevNum, BootProfile, BootInfo);

if Status == 0
    get(BootProfile);%打印BootInfo的值
    get(BootInfo);%打印BootInfo的值    
    fprintf('Device successfully\n');
else
    % 设备打开失败，根据不同的错误状态进行处理
    switch Status
        case -1
            fprintf('Error - Check the power supply of the device, the connection of the data cable, and check that the driver is installed correctly\n');
        case -3
            fprintf('Error - RF calibration file is missing, please copy the RF calibration file to the CalFile folder\n');
        case -4
            fprintf('Error - IF calibration file is missing, please copy the IF calibration file to the CalFile folder\n');
        case -5
            fprintf('Error - Profile is missing, please copy the profile to the CalFile folder\n');
        case -6
            fprintf('Error - The device spec file is missing, please copy the device spec file to the CalFile folder\n');
        otherwise
            fprintf('Device turn on failed: Returns another error Status = %d', Status);
    end

    % 返回错误状态值
    return ;
end

% 直接加载GNSSInfo_TypeDef结构体
load(fullfile(filePath, 'GNSSInfo.mat'));  
GNSSInfo.GNSS_LockState=0;
GNSSInfo.GNSSAntennaState=0;
Status = calllib('htra_api', 'Device_SetGNSSAntennaState', Device, GNSSInfo.GNSSAntennaState);

while ~GNSSInfo.GNSS_LockState
    % 获取 GNSS 实时信息
    Status = calllib('htra_api', 'Device_GetGNSSInfo_Realtime', Device, GNSSInfo);
    disp(['GNSS_LockState: ', num2str(GNSSInfo.GNSS_LockState)]);
    pause(1);  

end

get(GNSSInfo); %打印GNSSInfo_p的值

%  BootInfo.DeviceInfo.HardwareVersion 是硬件版本号
HardwareVersion = BootInfo.DeviceInfo.HardwareVersion;

% 提取 OCXO_Enable 的值
OCXO_Enable = bitand(bitshift(HardwareVersion, -10), 3);
%设置DOCXO的工作模式为驯服模式（必须在天线锁定后设置才生效）
GNSSInfo.DOCXO_WorkMode = 0;
% 判断 OCXO 是否启用
if OCXO_Enable 
    %设置GNSS中DOCXO工作状态
    Status = calllib('htra_api', 'Device_SetDOCXOWorkMode', Device,GNSSInfo.DOCXO_WorkMode);

    % 获取当前时间
    startTime = tic;  % 开始计时
    %如果DOCXO已锁定
    if GNSSInfo.DOCXO_LockState == 1
       disp(['GNSS_LockState: ', num2str(int16(GNSSInfo.GNSS_LockState))]);
       disp(['DOCXO_LockState: ', num2str(int16(GNSSInfo.DOCXO_LockState))]);
    else
        while 1
            % 获取GNSS中DOCXO工作状态
            Status = calllib('htra_api', 'Device_GetGNSSInfo_Realtime', Device, GNSSInfo);

            % 检查锁定状态
            if GNSSInfo.DOCXO_LockState == 1 && GNSSInfo.GNSS_LockState == 1
                disp(['GNSS_LockState: ', num2str(int16(GNSSInfo.GNSS_LockState))]);
                disp(['DOCXO_LockState: ', num2str(int16(GNSSInfo.DOCXO_LockState))]);
                break;
            end

            if GNSSInfo.GNSS_LockState == 0
                GNSSInfo.DOCXO_WorkMode = 1;
                %设置GNSS中DOCXO工作状态
                Status = calllib('htra_api', 'Device_SetDOCXOWorkMode', Device,GNSSInfo.DOCXO_WorkMode);
            end
            disp(['GNSS_LockState: ', num2str(int16(GNSSInfo.GNSS_LockState))]);
            % 打印当前状态
            disp(['DOCXO_LockState: ', num2str(int16(GNSSInfo.DOCXO_LockState))]);

            % 检查超时：是否超过180秒
            elapsedTime = toc(startTime);  % 获取经过的时间
            if elapsedTime > 600
                disp('The DOCXO is not locked, please check whether the cable connection is normal.');
                break;
            end
            pause(1);  % 延时1秒
        end
    end
end

%调用Device_Close函数
Status = calllib('htra_api', 'Device_Close', Device);

clear all;
%卸载库文件
unloadlibrary('htra_api');   
disp('Uninstall complete')











