% 配置编译环境
% setenv('MW_MINGW64_LOC','D:\msys64\ucrt64');
% mex -setup C++

filePath = fullfile(pwd, 'htra_api_mat');  

% 检查文件夹是否存在，如果不存在，创建文件夹
if ~exist(filePath, 'dir')
    run('htra_api.m');
    filePath = fullfile(pwd, 'htra_api_mat');  
end

%加载htra_api.dll
if not(libisloaded('htra_api.dll'))   
    loadlibrary('.\htra_api\htra_api.dll','.\htra_api\htra_api.h'); %.dll和.h的文件路径一定要注意
end

libfunctions('htra_api'); %查看API中的所有函数

%打开设备
Device = libpointer; %创建Device指针
DevNum = 0;
Status = 0;

APIVersion = uint32(calllib('htra_api', 'Get_APIVersion'));  % 确保 apiVersion 是 uint32 类型

% 使用提供的位运算方法提取版本号
major = bitshift(APIVersion, -16);                   % 提取高16位（主版本号）
minor = bitshift(bitand(APIVersion, 65535), -8);    % 提取中间8位（次版本号）
rev = bitand(APIVersion, 255);                      % 提取低8位（修订号）

% 打印API版本信息
fprintf('htra_api version: %d.%d.%d\n', major, minor, rev);

load(fullfile(filePath, 'BootProfile.mat'));  % 直接加载文件
load(fullfile(filePath, 'BootInfo.mat'));  % 直接加载文件

IS_USB = 1;  % 默认为 USB 设备，如果使用网口型设备则设置为 0

if IS_USB == 1
    % 配置 USB 接口
    BootProfile.PhysicalInterface = 0;
else
    % 配置 ETH 接口
    BootProfile.PhysicalInterface = 3;
    BootProfile.ETH_IPVersion = 0;
    BootProfile.ETH_RemotePort = 5000;
    BootProfile.ETH_ReadTimeOut = 5000;
    BootProfile.ETH_IPAddress = [192, 168, 1, 100];
end

%调用Device_Open函数
Status = calllib('htra_api', 'Device_Open', Device, DevNum, BootProfile, BootInfo);

if Status == 0
    get(BootProfile);%打印BootInfo的值
    get(BootInfo);%打印BootInfo的值    
    fprintf('Device successfully\n');
else
    % 设备打开失败，根据不同的错误状态进行处理
    switch Status
        case -1
            fprintf('Error - Check the power supply of the device, the connection of the data cable, and check that the driver is installed correctly\n');
        case -3
            fprintf('Error - RF calibration file is missing, please copy the RF calibration file to the CalFile folder\n');
        case -4
            fprintf('Error - IF calibration file is missing, please copy the IF calibration file to the CalFile folder\n');
        case -5
            fprintf('Error - Profile is missing, please copy the profile to the CalFile folder\n');
        case -6
            fprintf('Error - The device spec file is missing, please copy the device spec file to the CalFile folder\n');
        otherwise
            fprintf('Device turn on failed: Returns another error Status = %d', Status);
    end

    % 返回错误状态值
    return ;
end

% 显示设备UID
fprintf('DeviceInfo.DeviceUID: %s\n', sprintf('0x%016X\n', uint64(vpa(BootInfo.DeviceInfo.DeviceUID))));
% disp(uint64(BootInfo.DeviceInfo.DeviceUID));

if BootInfo.DeviceInfo.Model == 11
    str = 'E90_R1';
elseif BootInfo.DeviceInfo.Model == 12
    str = 'E90_R2';
elseif BootInfo.DeviceInfo.Model == 13
    str = 'E90_R3';
elseif BootInfo.DeviceInfo.Model == 22
    str = 'E200_R2';
elseif BootInfo.DeviceInfo.Model == 23
    str = 'E200_R3';
elseif BootInfo.DeviceInfo.Model == 53
    str = 'N60_R4';
elseif BootInfo.DeviceInfo.Model == 54
    str = 'M60_R4';
elseif BootInfo.DeviceInfo.Model == 55
    str = 'N45_R4';
elseif BootInfo.DeviceInfo.Model == 56
    str = 'M80_R5';
elseif BootInfo.DeviceInfo.Model == 57
    str = 'M60_R5';
elseif BootInfo.DeviceInfo.Model == 58
    str = 'N60_R5';
elseif BootInfo.DeviceInfo.Model == 59
    str = 'N45_R5';
elseif BootInfo.DeviceInfo.Model == 91
    str = 'N400_R1';
elseif BootInfo.DeviceInfo.Model == 94
    str = 'N400_R2';
else
    str = 'Unknown_Model';
end

% 显示设备型号
disp(['The device model is ', str]);

fprintf('BusSpeed:  %d.\n',BootInfo.BusSpeed);

% 显示设备MCU版本和FPGA版本
MFM = uint32(BootInfo.DeviceInfo.MFWVersion); % 强制转换为 uint32 类型
FPGA = uint32(BootInfo.DeviceInfo.FFWVersion); % 强制转换为 uint32 类型

x1 = bitshift(MFM, -16);     % 提取高16位
y1 = bitshift(bitand(MFM, 65535), -8);  % 提取中间8位
z1 = bitand(MFM, 255);       % 提取低8位

x2 = bitshift(FPGA, -16);    % 提取高16位
y2 = bitshift(bitand(FPGA, 65535), -8); % 提取中间8位
z2 = bitand(FPGA, 255);      % 提取低8位

fprintf('The MFM version of the device is %d.%d.%d\n', x1, y1, z1);
fprintf('The FPGA version of the device is %d.%d.%d\n', x2, y2, z2);

% 显示设备温度
load(fullfile(filePath, 'DeviceState.mat'));  % 直接加载DeviceState.mat文件
Status = calllib('htra_api', 'Device_QueryDeviceState_Realtime', Device,DeviceState);
fprintf('Device Temperature： %2f\n',DeviceState.Temperature * 0.01);

%调用Device_Close函数
Status = calllib('htra_api', 'Device_Close', Device);

clear all;

%卸载库文件
unloadlibrary('htra_api');   
disp('Uninstall complete')






