% 配置编译环境
% setenv('MW_MINGW64_LOC','D:\msys64\ucrt64');
% mex -setup C++

filePath = fullfile(pwd, 'htra_api_mat');  

% 检查文件夹是否存在，如果不存在，创建文件夹
if ~exist(filePath, 'dir')
    run('htra_api.m');
    filePath = fullfile(pwd, 'htra_api_mat');  
end

%加载htra_api.dll
if not(libisloaded('htra_api.dll'))   
    loadlibrary('.\htra_api\htra_api.dll','.\htra_api\htra_api.h'); %.dll和.h的文件路径一定要注意
end

libfunctions('htra_api'); %查看API中的所有函数

%打开设备
Device = libpointer; %创建Device指针
DevNum = 0;
Status = 0;

load(fullfile(filePath, 'BootProfile.mat'));  % 直接加载BootProfile_TypeDef结构体
load(fullfile(filePath, 'BootInfo.mat'));  % 直接加载BootInfo_TypeDef结构体
load(fullfile(filePath, 'DeviceState.mat'));  % 直接加载DeviceState_TypeDef结构体

IS_USB = 1;  % 默认为 USB 设备，如果使用网口型设备则设置为 0

if IS_USB == 1
    % 配置 USB 接口
    BootProfile.PhysicalInterface = 0;
else
    % 配置 ETH 接口
    BootProfile.PhysicalInterface = 3;
    BootProfile.ETH_IPVersion = 0;
    BootProfile.ETH_RemotePort = 5000;
    BootProfile.ETH_ReadTimeOut = 5000;
    BootProfile.ETH_IPAddress = [192, 168, 1, 100];
end

%调用Device_Open函数
Status = calllib('htra_api', 'Device_Open', Device, DevNum, BootProfile, BootInfo);

if Status == 0
    get(BootProfile);%打印BootInfo的值
    get(BootInfo);%打印BootInfo的值    
    fprintf('Device successfully\n');
else
    % 设备打开失败，根据不同的错误状态进行处理
    switch Status
        case -1
            fprintf('Error - Check the power supply of the device, the connection of the data cable, and check that the driver is installed correctly\n');
        case -3
            fprintf('Error - RF calibration file is missing, please copy the RF calibration file to the CalFile folder\n');
        case -4
            fprintf('Error - IF calibration file is missing, please copy the IF calibration file to the CalFile folder\n');
        case -5
            fprintf('Error - Profile is missing, please copy the profile to the CalFile folder\n');
        case -6
            fprintf('Error - The device spec file is missing, please copy the device spec file to the CalFile folder\n');
        otherwise
            fprintf('Device turn on failed: Returns another error Status = %d', Status);
    end

    % 返回错误状态值
    return ;
end

load(fullfile(filePath, 'IQS_Profile.mat'));  % 直接加载IQS_Profile_TypeDef结构体

%定义IQS_ProfileIn指针和IQS_ProfileOut指针
IQS_ProfileIn = IQS_Profile;
IQS_ProfileOut = IQS_Profile;

%调用IQS_ProfileDeInit函数
Status = calllib('htra_api', 'IQS_ProfileDeInit', Device, IQS_ProfileIn);
get(IQS_ProfileIn); %打印IQS_ProfileIn的值

%修改IQS模式的参数
IQS_ProfileIn.CenterFreq_Hz = 1e9;   %配置中心频率
IQS_ProfileIn.RefLevel_dBm = 0;      %配置参考电平
IQS_ProfileIn.DecimateFactor = 2;    %配置抽取倍数
IQS_ProfileIn.TriggerMode= 1;         %配置触发模式。
IQS_ProfileIn.TriggerLength = 16242; %配置单次触发采集的点数

% 直接加载IQS_StreamInfo_TypeDef结构体
load(fullfile(filePath, 'IQS_StreamInfo.mat'));  

%调用IQS_Configuration函数
Status = calllib('htra_api', 'IQS_Configuration', Device, IQS_ProfileIn, IQS_ProfileOut,IQS_StreamInfo);

% 如果配置下发成功（Status == 0）
if Status == 0
    get(IQS_ProfileOut); %打印IQS_ProfileOut的值
    get(IQS_StreamInfo); %打印StreamInfo的值
    fprintf('Configuration successfully\n');
else
    % 如果调用出错，打印错误信息并关闭设备
    fprintf('IQS_Configuration Call error Status = %d\n', Status);
    
    % 关闭设备的函数（Device_Close）。
    Device_Close(Device);  
    
    % 返回 0，结束函数执行
    return;
end

% 直接加载IQS_TriggerInfo_TypeDef结构体
load(fullfile(filePath, 'TriggerInfo.mat'));  

% 直接加载MeasAuxInfo_TypeDef结构体
load(fullfile(filePath, 'MeasAuxInfo.mat'));

DSP = libpointer; %创建 DSP 指针
Status = calllib('htra_api', 'DSP_Open', DSP);

% 直接加载DSP_FFT_TypeDef结构体
load(fullfile(filePath, 'DSP_FFT.mat'));  

%定义DSP_FFTIn指针和DSP_FFTOut指针
DSP_FFTIn = DSP_FFT;
DSP_FFTOut = DSP_FFT;

% 定义一个无符号32位整数，初始值为0
TracePoints = uint32(0);  
TracePoints_p = libpointer('uint32Ptr',TracePoints);
Status = calllib('htra_api', 'DSP_FFT_DeInit', DSP_FFTIn);

DSP_FFTIn.Calibration=0;                                                        %配置是否开启校准，0则不开校准，其他值开启。
DSP_FFTIn.DetectionRatio=1;                                                     %配置检波率。
DSP_FFTIn.TraceDetector=2;                                                      %配置检波方式。
DSP_FFTIn.FFTSize=IQS_StreamInfo.PacketSamples * IQS_StreamInfo.PacketCount;    %配置FFT点数。
DSP_FFTIn.Intercept=1;                                                          %配置截取率。
DSP_FFTIn.SamplePts=IQS_StreamInfo.PacketSamples  * IQS_StreamInfo.PacketCount; %配置采样点数。
DSP_FFTIn.WindowType=0;%配置窗型。

% 定义一个双精度浮点数
RBWRatio = 0;  
RBWRatio_p = libpointer('doublePtr',RBWRatio);
Status = calllib('htra_api', 'DSP_FFT_Configuration',DSP, DSP_FFTIn,DSP_FFTOut,TracePoints_p,RBWRatio_p);

%创建Frequency，存放SWP的频谱数据
Frequency = double(1:TracePoints_p.Value);
%创建PowerSpec_dBm，存放SWP的幅度数据
Spectrum = single(1:TracePoints_p.Value);
disp(TracePoints_p.Value)

%创建Frequency_p，存放SWP的频谱数据
Frequency_p = libpointer('doublePtr',Frequency);
Spectrum_p = libpointer('singlePtr',Spectrum);

% 直接加载IQStream_TypeDef结构体
load(fullfile(filePath, 'IQStream.mat'));  

n = 10000;
% 根据 TriggerMode 值决定调用 IQS_BusTriggerStart 的位置
if strcmp(IQS_ProfileOut.TriggerMode, 'Adaptive')
% 当 TriggerMode == Adaptive 时，先执行一次 IQS_BusTriggerStart
Status = calllib('htra_api', 'IQS_BusTriggerStart', Device);
end
for j = 1:n
    % 如果 TriggerMode == FixedPoints，则每次循环时执行 IQS_BusTriggerStart
    if strcmp(IQS_ProfileOut.TriggerMode, 'FixedPoints')
        Status = calllib('htra_api', 'IQS_BusTriggerStart', Device);
    end
    for i=1:IQS_StreamInfo.PacketCount      
        Status = calllib('htra_api', 'IQS_GetIQStream_PM1', Device, IQStream);      
        if Status ~= 0
            % 如果调用出错，打印错误信息并关闭设备
            fprintf('IQS_GetIQStream Call error Status = %d\n', Status);
            % 返回 0，结束函数执行
            return;
        end
    end
    Status = calllib('htra_api', 'DSP_FFT_IQSToSpectrum',DSP, IQStream,Frequency_p,Spectrum_p);   

    if Status ~= 0
        % 如果调用出错，打印错误信息并关闭设备
        fprintf('DSP_FFT_IQSToSpectrum Call error Status = %d\n', Status);
        % 返回 0，结束函数执行
        return;
    end
    %画出SWP的频谱图
    plot(Frequency_p.Value,Spectrum_p.Value);
    ylim([-130, IQStream.IQS_Profile.RefLevel_dBm]);
    xlim([min(Frequency_p.Value), max(Frequency_p.Value)]);
    pause(0.01);
end
%调用 IQS_BusTriggerStop 函数
Status = calllib('htra_api', 'IQS_BusTriggerStop', Device);

%调用 DSP_Close 函数
Status = calllib('htra_api', 'DSP_Close', DSP);

%调用 Device_Close 函数
Status = calllib('htra_api', 'Device_Close', Device);

clear all;

%卸载库文件
unloadlibrary('htra_api');   
disp('Uninstall complete')



