﻿#include <stdio.h>
#include <iostream>
#include <string.h>
#include <vector>
#include "example.h"
#include "htra_api.h"
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int SWP_GetSpectrum_Trigger()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。

	Device_Open_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。
	
	SWP_Profile_TypeDef SWP_ProfileIn;  //SWP输入配置，包括起始频率、终止频率、RBW、参考电平等。
	SWP_Profile_TypeDef SWP_ProfileOut; //SWP输出配置。
	SWP_TraceInfo_TypeDef TraceInfo;    //当前配置下的迹线信息，包括迹线点数、跳频点数等。

	SWP_ProfileDeInit(&Device, &SWP_ProfileIn); //初始化SWP模式的相关参数。

	SWP_ProfileIn.StartFreq_Hz = 9e3;   //配置起始频率。
	SWP_ProfileIn.StopFreq_Hz = 6.35e9; //配置终止频率。
	SWP_ProfileIn.RBW_Hz = 300e3;       //配置RBW。

#define TRIGGER 2 //修改TRIGGER的值为0、1、2来可按需配置触发源

#if TRIGGER == 0
	/* 内部触发自由运行（总线触发） */
	SWP_ProfileIn.TriggerSource = InternalFreeRun;

#elif TRIGGER == 1
	/* 外部触发，每一次触发都跳一个频点 */
	SWP_ProfileIn.TriggerSource = ExternalPerHop;

#elif TRIGGER==2
	/* 外部触发，每一次触发都刷新一条迹线 */
	SWP_ProfileIn.TriggerSource = ExternalPerSweep;
#else
	/* 外部触发，每一次触发都应用一个新配置 */
	SWP_ProfileIn.TriggerSource = ExternalPerProfile;
#endif

	Status = SWP_Configuration(&Device, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo);                                               //通过调用此函数下发SWP模式的相关配置。

	SWP_Configuration_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。
	
	//获取SWP模式下部分扫描的频谱数据
	vector<double> Frequency(TraceInfo.FullsweepTracePoints);    //创建频率数组。
	vector<float> PowerSpec_dBm(TraceInfo.FullsweepTracePoints); //创建功率数组。
	int HopIndex = 0;                                            //当前跳频点索引。
	int FrameIndex = 0;                                          //当前帧索引。
	MeasAuxInfo_TypeDef MeasAuxInfo;                             //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

	//循环获取数据。
	while (1)
	{
		for (int i = 0; i < TraceInfo.TotalHops; i++) //TraceInfo.TotalHops代表当前配置下的帧数，因此循环TraceInfo.TotalHops次调用SWP_GetPartialSweep即可得到完整迹线。
		{
			Status = SWP_GetPartialSweep(&Device, Frequency.data() + i * TraceInfo.PartialsweepTracePoints, PowerSpec_dBm.data() + i * TraceInfo.PartialsweepTracePoints, &HopIndex, &FrameIndex, &MeasAuxInfo); //获取频谱数据。

			if (Status == APIRETVAL_NoError)
			{
				// UserCode here
				/*

				例如：显示频谱 或 对频谱做其他处理等

				*/
			}

			else //当Status不为0时，根据Status的返回值进行相对应的错误处理。
			{
				SWP_ErrorHandlingExceptOpenAndConfiguration(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo);
			}
		}
	}

	Device_Close(&Device); //关闭设备。

	return 0;
}