﻿#include <iostream>
#include <vector>
#include <string>
#include <map>
#include "htra_api.h"
#include "example.h"
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int Device_GetDeviceInfo()
{
	map<uint16_t, string> ModelToDevName; //Model映射DevName。
	ModelToDevName[12] = "E90 R2";
	ModelToDevName[13] = "E90 R3";
	ModelToDevName[22] = "E200 R2";
	ModelToDevName[23] = "E200 R3";
	ModelToDevName[53] = "N60 R4";
	ModelToDevName[54] = "M60 R4";
	ModelToDevName[55] = "N45 R4";
	ModelToDevName[56] = "M80 R5";
	ModelToDevName[57] = "M60 R5";
	ModelToDevName[58] = "N60 R5";
	ModelToDevName[59] = "N45 R5";
	ModelToDevName[94] = "N400 R2V2";

	int apiVersion = Get_APIVersion();
	int major = 0, minor = 0, rev = 0;
	major = (apiVersion >> 16) & 0xffff;
	minor = (apiVersion >> 8) & 0xff;
	rev = apiVersion & 0xff;
	cout << "htra_api verion: " << major << "." << minor << "." << rev << endl; //打印htra_api版本。

	int Status = 0;
	void* Device = NULL;
	int DevNum = 0;

	BootProfile_TypeDef BootProfile; //启动配置。
	BootInfo_TypeDef BootInfo;       //启动信息。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort;

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。

	Device_Open_ErrorHandling(Status,&Device,DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	//打印设备信息
	cout << "BusSpeed: " << BootInfo.BusSpeed << endl; //BootInfo.BusSpeed: 3为USB3.0, 2为USB2.0。
	cout << "Model: " << BootInfo.DeviceInfo.Model << ", " << ModelToDevName[BootInfo.DeviceInfo.Model] << endl;
	cout << std::hex << "DeviceInfo.DeviceUID: " << BootInfo.DeviceInfo.DeviceUID << std::dec << endl; //打印16进制的设备UID

	//打印MCU固件版本
	major = (BootInfo.DeviceInfo.MFWVersion >> 16) & 0xffff;
	minor = (BootInfo.DeviceInfo.MFWVersion >> 8) & 0xff;
	rev = BootInfo.DeviceInfo.MFWVersion & 0xff;
	cout << "MCU Firmware: " << major << "." << minor << "." << rev << endl;

	//打印FPGA固件版本
	major = (BootInfo.DeviceInfo.FFWVersion >> 16) & 0xffff;
	minor = (BootInfo.DeviceInfo.FFWVersion >> 8) & 0xff;
	rev = BootInfo.DeviceInfo.FFWVersion & 0xff;
	cout << "FPGA Firmware: " << major << "." << minor << "." << rev << endl;

	//若Device_Open返回非0，则程序结束。
	if (Status) {
		return 0;
	}

	DeviceInfo_TypeDef DeviceInfo;
	Status = Device_QueryDeviceInfo_Realtime(&Device, &DeviceInfo); //查询设备信息。

	DeviceState_TypeDef DeviceState;
	Status = Device_QueryDeviceState_Realtime(&Device, &DeviceState); //查询设备状态。
	cout << "Device Temperature: " << DeviceState.Temperature * 0.01 << "℃" << endl;

	Device_Close(&Device); //关闭设备。	
	return 0;
}