﻿#include <stdio.h>
#include <string.h>
#include <vector>
#include "example.h"
#include "htra_api.h"
using namespace std;

#define IS_USB 1 //默认使用的是USB型设备，若使用的是网口型设备则将IS_USB定义为0。

int ASG_SignalOutput()
{
	int Status = 0;      //函数的返回。
	void* Device = NULL; //当前设备的内存地址。
	int DevNum = 0;      //指定设备号。

	BootProfile_TypeDef BootProfile; //启动配置结构体，包括物理接口、供电方式等。
	BootInfo_TypeDef BootInfo;       //启动信息结构体，包括设备信息、USB速率等。

	BootProfile.DevicePowerSupply = USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

#if IS_USB==1
	//配置USB接口。
	BootProfile.PhysicalInterface = USB;
#else 
	//配置ETH接口。
	BootProfile.PhysicalInterface = ETH;
	BootProfile.ETH_IPVersion = IPv4;
	BootProfile.ETH_RemotePort = 5000;
	BootProfile.ETH_ReadTimeOut = 5000;
	BootProfile.ETH_IPAddress[0] = 192;
	BootProfile.ETH_IPAddress[1] = 168;
	BootProfile.ETH_IPAddress[2] = 1;
	BootProfile.ETH_IPAddress[3] = 100;
#endif

	Status = Device_Open(&Device, DevNum, &BootProfile, &BootInfo); //打开设备。

	Device_Open_ErrorHandling(Status,&Device, DevNum, &BootProfile, &BootInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	SWP_Profile_TypeDef SWP_ProfileIn;  //SWP输入配置，包括起始频率、终止频率、RBW、参考电平等。
	SWP_Profile_TypeDef SWP_ProfileOut; //SWP输出配置。
	SWP_TraceInfo_TypeDef TraceInfo;    //当前配置下的迹线信息，包括迹线点数、跳频点数等。

	SWP_ProfileDeInit(&Device, &SWP_ProfileIn); //初始化配置SWP模式的相关参数。

	SWP_ProfileIn.StartFreq_Hz = 1e9; //配置起始频率。
	SWP_ProfileIn.StopFreq_Hz = 2e9;  //配置终止频率。

	Status = SWP_Configuration(&Device, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //下发SWP模式的相关配置。

	SWP_Configuration_ErrorHandling(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。

	ASG_Profile_TypeDef ASG_ProfileIn;  //ASG输入配置，包括信号源输出模式、各模式下频率，功率等参数设置。
	ASG_Profile_TypeDef ASG_ProfileOut; //ASG输出配置。
	ASG_Info_TypeDef ASG_Info;         //当前配置下扫描点数的信息。

	ASG_ProfileDeInit(&Device, &ASG_ProfileIn); //初始化配置ASG模式的相关参数。

#define SIGNAL_CW 1              //所需信号为单音信号，请将此值设置为1。
#define SIGNAL_Frequency_sweep 0 //所需信号为频率扫描信号，请将此值设置为1。
#define SIGNAL_Power_sweep 0     //所需信号为功率扫描信号，请将此值设置为1。

#if SIGNAL_CW == 1
	/* 单音信号 */
	ASG_ProfileIn.CenterFreq_Hz = 1.51e9;
	ASG_ProfileIn.Level_dBm = 0;
	ASG_ProfileIn.Mode = ASG_FixedPoint;

#elif SIGNAL_Frequency_sweep == 1
	/* 频率扫描信号 */
	ASG_ProfileIn.StartFreq_Hz = 1.2e9;
	ASG_ProfileIn.StopFreq_Hz = 1.4e9;
	ASG_ProfileIn.StepFreq_Hz = 1e6;
	ASG_ProfileIn.Level_dBm = -20;
	ASG_ProfileIn.Mode = ASG_FrequencySweep;

#elif SIGNAL_Power_sweep == 1
	/* 功率扫描信号 */
	ASG_ProfileIn.CenterFreq_Hz = 1.6e9;
	ASG_ProfileIn.StartLevel_dBm = -30;
	ASG_ProfileIn.StopLevel_dBm = -20;
	ASG_ProfileIn.Mode = ASG_PowerSweep;

#endif

	ASG_Configuration(&Device, &ASG_ProfileIn, &ASG_ProfileOut, &ASG_Info); //下发ASG模式的相关配置。

	vector<double> Frequency(TraceInfo.FullsweepTracePoints);    //创建频率数组。
	vector<float> PowerSpec_dBm(TraceInfo.FullsweepTracePoints); //创建功率数组。
	MeasAuxInfo_TypeDef MeasAuxInfo;                             //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

	//循环获取频谱数据。
	while (1)
	{
		Status = SWP_GetFullSweep(&Device, Frequency.data(), PowerSpec_dBm.data(), &MeasAuxInfo); //获取迹线。
		
		
		SWP_ErrorHandlingExceptOpenAndConfiguration(Status, &Device, DevNum, &BootProfile, &BootInfo, &SWP_ProfileIn, &SWP_ProfileOut, &TraceInfo); //当Status不为0时，根据Status的返回值进行相对应的错误处理。
	}

	Device_Close(&Device); //关闭设备。

	return 0;
}