﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HTRA_CSharp_Examples
{
    class RTA_GetRealTimeSpectrum_Standard
    {
		public void Example()
		{
			#region 1 打开设备

			int Status = 0;              //函数的返回。
			IntPtr Device = IntPtr.Zero; //当前设备的内存地址。
			int DevNum = 0;              //指定设备号。

			HtraApi.BootProfile_TypeDef BootProfile = new HtraApi.BootProfile_TypeDef(); //启动配置结构体，包括物理接口、供电方式等。
			HtraApi.BootInfo_TypeDef BootInfo = new HtraApi.BootInfo_TypeDef();          //启动信息结构体，包括设备信息、USB速率等。

			BootProfile.DevicePowerSupply = HtraApi.DevicePowerSupply_TypeDef.USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

			//设备数据接口为USB时直接运行，为网口时将 #if true 改为 #if false
#if true
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.USB;
#else
			//配置网络相关参数
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.ETH;
			BootProfile.ETH_IPVersion = HtraApi.IPVersion_TypeDef.IPv4;
			BootProfile.ETH_RemotePort = 5000;
			BootProfile.ETH_ReadTimeOut = 5000;
			BootProfile.ETH_IPAddress = new byte[16];
			BootProfile.ETH_IPAddress[0] = 192;
			BootProfile.ETH_IPAddress[1] = 168;
			BootProfile.ETH_IPAddress[2] = 1;
			BootProfile.ETH_IPAddress[3] = 100;
#endif

			Status = HtraApi.Device_Open(ref Device, DevNum, ref BootProfile, ref BootInfo); //打开设备

			if (Status == 0)
			{
				System.Console.WriteLine("Device is opened successfully");
			}

			/*设备打开失败，返回错误提示，发生以下错误时，设备无法正常运行，建议按照提示操作后重新打开设备*/
			else
			{
				switch (Status)
				{
					case HtraApi.APIRETVAL_ERROR_BusOpenFailed:
						System.Console.WriteLine("Error - Check the device power supply, data cable connection and driver installation");
						return;

					case HtraApi.APIRETVAL_ERROR_RFACalFileIsMissing:
						System.Console.WriteLine("Error - RF calibration file is missing");
						return;

					case HtraApi.APIRETVAL_ERROR_IFACalFileIsMissing:
						System.Console.WriteLine("Error - IF calibration file is missing");
						return;

					case HtraApi.APIRETVAL_ERROR_DeviceConfigFileIsMissing:
						System.Console.WriteLine("Error - Configuration file missing");
						return;

					case HtraApi.APIRETVAL_ERROR_DeviceSpecFileIsMissing:
						System.Console.WriteLine("Error - Device specification file is missing");
						return;

					default:
						System.Console.WriteLine("Return other errors！ Status = " + Status);
						return;
				}
			}
			#endregion

			#region 2 配置参数
			HtraApi.RTA_Profile_TypeDef RTA_ProfileIn = new HtraApi.RTA_Profile_TypeDef();  //RTA输入配置，包括中心频率、抽取倍数、参考电平等。 
			HtraApi.RTA_Profile_TypeDef RTA_ProfileOut = new HtraApi.RTA_Profile_TypeDef(); //RTA输出配置。
			HtraApi.RTA_FrameInfo_TypeDef FrameInfo = new HtraApi.RTA_FrameInfo_TypeDef();  //当前配置下的RTA数据相关信息，包括起始频率、终止频率、数据点数等。

			HtraApi.RTA_ProfileDeInit(ref Device, ref RTA_ProfileIn); //初始化配置RTA模式的相关参数。

			RTA_ProfileIn.CenterFreq_Hz = 1e9;									 //配置中心频率。
			RTA_ProfileIn.RefLevel_dBm = 0;										 //配置参考电平。
			RTA_ProfileIn.DecimateFactor = 1;									 //配置抽取倍数。
			RTA_ProfileIn.TriggerSource = HtraApi.RTA_TriggerSource_TypeDef.Bus; //配置触发源为内部总线触发。

			//配置触发模式。FixedPoints模式是触发信号的上升沿开始采样，采到TriggerAcqTime时长后结束采样。Adaptive模式是触发信号的上升沿开始采样，下降沿结束采样。
			//使用Adaptive模式直接运行，使用FixedPoints模式则将 #if true 改为 #if false
#if true
			RTA_ProfileIn.TriggerMode = HtraApi.TriggerMode_TypeDef.Adaptive;               
#else
			//配置FixedPoints模式相关参数
			RTA_ProfileIn.TriggerMode = HtraApi.TriggerMode_TypeDef.FixedPoints;              
			RTA_ProfileIn.TriggerAcqTime = 0.1; //配置触发后的采样时间为0.1s，仅在FixedPoints模式下生效。
#endif

			Status = HtraApi.RTA_Configuration(ref Device, ref RTA_ProfileIn, ref RTA_ProfileOut, ref FrameInfo); //下发RTA模式的相关配置。

			if (Status == 0)
			{
				System.Console.WriteLine("configuration delievery succeeded");
			}
			else
			{
				System.Console.WriteLine("SWP_Configuration call is incorrect,Status = " + Status);
				HtraApi.Device_Close(ref Device);
			}
			#endregion

			#region 3 数据采集
			byte[] SpectrumTrace = new byte[FrameInfo.PacketValidPoints];                                     //频谱数组
			System.UInt16[] SpectrumBitmap = new System.UInt16[FrameInfo.FrameHeight * FrameInfo.FrameWidth]; //频谱位图数组
			float[] Spectrum = new float[FrameInfo.FrameWidth];                                               //dBm单位的频谱数组
			HtraApi.RTA_PlotInfo_TypeDef RTA_PlotInfo = new HtraApi.RTA_PlotInfo_TypeDef();                   //绘图信息
			HtraApi.RTA_TriggerInfo_TypeDef TriggerInfo = new HtraApi.RTA_TriggerInfo_TypeDef();              //触发信息
			HtraApi.MeasAuxInfo_TypeDef MeasAuxInfo = new HtraApi.MeasAuxInfo_TypeDef();                      //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

			//使用Adaptive模式直接运行，使用FixedPoints模式则将 #if true 改为 #if false
#if true
			Status = HtraApi.RTA_BusTriggerStart(ref Device); //调用RTA_BusTriggerStart触发设备。
			while (true)
			{
				Status = HtraApi.RTA_GetRealTimeSpectrum(ref Device, SpectrumTrace, SpectrumBitmap, ref RTA_PlotInfo, ref TriggerInfo, ref MeasAuxInfo); //获取RTA数据及触发信息。

				if (Status == 0)
				{

					//UserCode here
					//操作范例开始，以下是一个将RTA频谱数据的单位转换成dBm的范例
					for (int k = 0; k < FrameInfo.FrameWidth; k++)
					{
						Spectrum[k] = (float)SpectrumTrace[k] * RTA_PlotInfo.ScaleTodBm + RTA_PlotInfo.OffsetTodBm;
					}
					for (int j = 0; j < FrameInfo.FrameWidth; j++)
					{
						System.Console.WriteLine(Spectrum[j].ToString());
					}
					//操作范例结束
				}

				/*获取数据失败时，返回错误提示，发生以下错误时，建议按照提示进行操作*/
				else
				{
					switch (Status)
					{
						case HtraApi.APIRETVAL_WARNING_ReconfigurationIsRecommended:
							System.Console.WriteLine("Warning - The temperature of the current device varies greatly. It is recommended to reconfigure the temperature");
							break; //RTA_GetRealTimeSpectrum如果返回值为-14，建议重新配置参数后再获取。
						case HtraApi.APIRETVAL_WARNING_IFOverflow:
							System.Console.WriteLine("WARNING - IF saturation is recommended to be reconfigured, reference level <= signal power");
							break; //RTA_GetRealTimeSpectrum如果返回值为-12，建议重新配置参数获取。
						default:
							System.Console.WriteLine("If the status of the get function is incorrect, check the process of getting data");
							break;
					}
					System.Console.WriteLine("Status = " + Status);
					break;
				}
			}
#else
			while (true)
			{

				Status = HtraApi.RTA_BusTriggerStart(ref Device); //调用RTA_BusTriggerStart触发设备。

				for (System.UInt32 i = 0; i < FrameInfo.PacketCount; i++)
				{
					Status = HtraApi.RTA_GetRealTimeSpectrum(ref Device, SpectrumTrace, SpectrumBitmap, ref RTA_PlotInfo, ref TriggerInfo, ref MeasAuxInfo); //获取RTA数据及触发信息。
					if (Status == 0)
					{

						//UserCode here
						//操作范例开始，以下是一个将RTA频谱数据的单位转换成dBm的范例
						for (int k = 0; k < FrameInfo.FrameWidth; k++)
						{
							Spectrum[k] = (float)SpectrumTrace[k] * RTA_PlotInfo.ScaleTodBm + RTA_PlotInfo.OffsetTodBm;
						}
						for (int j = 0; j < FrameInfo.FrameWidth; j++)
						{
							System.Console.WriteLine(Spectrum[j].ToString());
						}
						//操作范例结束
					}

					/*获取数据失败时，返回错误提示，发生以下错误时，建议按照提示进行操作*/
					else
					{
						switch (Status)
						{
							case HtraApi.APIRETVAL_WARNING_ReconfigurationIsRecommended:
								System.Console.WriteLine("Warning - The temperature of the current device varies greatly. It is recommended to reconfigure the temperature");
								break; //RTA_GetRealTimeSpectrum如果返回值为-14，建议重新配置参数后再获取。
							case HtraApi.APIRETVAL_WARNING_IFOverflow:
								System.Console.WriteLine("WARNING - IF saturation is recommended to be reconfigured, reference level <= signal power");
								break; //RTA_GetRealTimeSpectrum如果返回值为-12，建议重新配置参数获取。
							default:
								System.Console.WriteLine("If the status of the get function is incorrect, check the process of getting data");
								break;
						}
						System.Console.WriteLine("Status = " + Status);
						break;
					}
				}
			}
#endif


			#endregion

			#region 4 关闭
			Status = HtraApi.RTA_BusTriggerStop(ref Device); //调用RTA_BusTriggerStop停止触发设备。
			HtraApi.Device_Close(ref Device);
			#endregion
		}
	}
}
