﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HTRA_CSharp_Examples
{
    class Device_GetDeviceInfo
    {
		public void Example()
		{
			//Model映射DevName
			Dictionary<ushort, string> ModelToDevName = new Dictionary<ushort, string>
			{
				{ 12, "E90 R2" },
				{ 13, "E90 R3" },
				{ 22, "E200 R2" },
				{ 23, "E200 R3" },
				{ 53, "N60 R4" },
				{ 54, "M60 R4" },
				{ 55, "N45 R4" },
				{ 56, "M80 R5" },
				{ 57, "M60 R5" },
				{ 58, "N60 R5" },
				{ 59, "N45 R5" },
				{ 94, "N400 R2V2" }
			};
			#region 1 打开设备
			int apiVersion = HtraApi.Get_APIVersion();
			int major = 0, minor = 0, rev = 0;
			major = (apiVersion >> 16) & 0xffff;
			minor = (apiVersion >> 8) & 0xff;
			rev = apiVersion & 0xff;
			Console.WriteLine($"htra_api version: {major}.{minor}.{rev}"); //打印htra_api版本

			int Status = 0;
			IntPtr Device = IntPtr.Zero;
			int DevNum = 0;

			HtraApi.BootProfile_TypeDef BootProfile = new HtraApi.BootProfile_TypeDef(); //启动配置																							 
			HtraApi.BootInfo_TypeDef BootInfo = new HtraApi.BootInfo_TypeDef();          //启动信息

			BootProfile.DevicePowerSupply = HtraApi.DevicePowerSupply_TypeDef.USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

			//设备数据接口为USB则直接运行，为网口则将 #if true 改为 #if false
#if true
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.USB;
#else
			//配置网络相关参数
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.ETH;
			BootProfile.ETH_IPVersion = HtraApi.IPVersion_TypeDef.IPv4;
			BootProfile.ETH_RemotePort = 5000;
			BootProfile.ETH_ReadTimeOut = 5000;
			BootProfile.ETH_IPAddress = new byte[16];
			BootProfile.ETH_IPAddress[0] = 192;
			BootProfile.ETH_IPAddress[1] = 168;
			BootProfile.ETH_IPAddress[2] = 1;
			BootProfile.ETH_IPAddress[3] = 100;
#endif

			Status = HtraApi.Device_Open(ref Device, DevNum, ref BootProfile, ref BootInfo); //打开设备
			Console.WriteLine($"Device_Open: {Status}");

			//打印设备信息
			Console.WriteLine($"BusSpeed: {BootInfo.BusSpeed}"); //BootInfo.BusSpeed: 3为USB3.0, 2为USB2.0
			Console.WriteLine($"Model: {BootInfo.DeviceInfo.Model},{ModelToDevName[BootInfo.DeviceInfo.Model]}");
			Console.WriteLine($"DeviceInfo.DeviceUID: {String.Format("{0:X}", BootInfo.DeviceInfo.DeviceUID)}");


			//打印MCU固件版本
			major = (int)(BootInfo.DeviceInfo.MFWVersion >> 16) & 0xffff;
			minor = (int)(BootInfo.DeviceInfo.MFWVersion >> 8) & 0xff;
			rev = (int)BootInfo.DeviceInfo.MFWVersion & 0xff;
			Console.WriteLine($"MCU Firmware: {major}.{minor}.{rev}");

			//打印FPGA固件版本
			major = (int)(BootInfo.DeviceInfo.FFWVersion >> 16) & 0xffff;
			minor = (int)(BootInfo.DeviceInfo.FFWVersion >> 8) & 0xff;
			rev = (int)BootInfo.DeviceInfo.FFWVersion & 0xff;
			Console.WriteLine($"FPGA Firmware: {major}.{minor}.{rev}");

			//若Device_Open返回非0，则程序结束

			HtraApi.DeviceInfo_TypeDef DeviceInfo = new HtraApi.DeviceInfo_TypeDef();
			Status = HtraApi.Device_QueryDeviceInfo_Realtime(ref Device, ref DeviceInfo); //查询设备信息

			HtraApi.DeviceState_TypeDef DeviceState = new HtraApi.DeviceState_TypeDef();
			Status = HtraApi.Device_QueryDeviceState_Realtime(ref Device, ref DeviceState); //查询设备状态
			Console.WriteLine($"Device Temperature: {DeviceState.Temperature * 0.01}℃");

			#endregion

			#region 3 关闭
			HtraApi.Device_Close(ref Device);
			#endregion
		}
	}
}
