﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HTRA_CSharp_Examples
{
    class DET_GetPowerTrace_Standard
    {
		public void Example()
		{
			#region 1 打开设备

			int Status = 0;              //函数的返回。
			IntPtr Device = IntPtr.Zero; //当前设备的内存地址。
			int DevNum = 0;              //指定设备号。

			HtraApi.BootProfile_TypeDef BootProfile = new HtraApi.BootProfile_TypeDef(); //启动配置结构体，包括物理接口、供电方式等。
			HtraApi.BootInfo_TypeDef BootInfo = new HtraApi.BootInfo_TypeDef();          //启动信息结构体，包括设备信息、USB速率等。

			BootProfile.DevicePowerSupply = HtraApi.DevicePowerSupply_TypeDef.USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

			//设备数据接口为USB时直接运行，为网口时将 #if true 改为 #if false
#if true
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.USB;
#else
			//配置网络相关参数
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.ETH;
			BootProfile.ETH_IPVersion = HtraApi.IPVersion_TypeDef.IPv4;
			BootProfile.ETH_RemotePort = 5000;
			BootProfile.ETH_ReadTimeOut = 5000;
			BootProfile.ETH_IPAddress = new byte[16];
			BootProfile.ETH_IPAddress[0] = 192;
			BootProfile.ETH_IPAddress[1] = 168;
			BootProfile.ETH_IPAddress[2] = 1;
			BootProfile.ETH_IPAddress[3] = 100;
#endif

			Status = HtraApi.Device_Open(ref Device, DevNum, ref BootProfile, ref BootInfo); //打开设备

			if (Status == 0)
			{
				System.Console.WriteLine("Device is opened successfully");
			}

			/*设备打开失败，返回错误提示，发生以下错误时，设备无法正常运行，建议按照提示操作后重新打开设备*/
			else
			{
				switch (Status)
				{
					case HtraApi.APIRETVAL_ERROR_BusOpenFailed:
						System.Console.WriteLine("Error - Check the device power supply, data cable connection and driver installation");
						return;

					case HtraApi.APIRETVAL_ERROR_RFACalFileIsMissing:
						System.Console.WriteLine("Error - RF calibration file is missing");
						return;

					case HtraApi.APIRETVAL_ERROR_IFACalFileIsMissing:
						System.Console.WriteLine("Error - IF calibration file is missing");
						return;

					case HtraApi.APIRETVAL_ERROR_DeviceConfigFileIsMissing:
						System.Console.WriteLine("Error - Configuration file missing");
						return;

					case HtraApi.APIRETVAL_ERROR_DeviceSpecFileIsMissing:
						System.Console.WriteLine("Error - Device specification file is missing");
						return;

					default:
						System.Console.WriteLine("Return other errors！ Status = " + Status);
						return;
				}
			}
			#endregion

			#region 2 配置参数
			HtraApi.DET_Profile_TypeDef DET_ProfileIn = new HtraApi.DET_Profile_TypeDef();    //DET输入配置，包括中心频率、抽取倍数、参考电平等等。
			HtraApi.DET_Profile_TypeDef DET_ProfileOut = new HtraApi.DET_Profile_TypeDef();   //DET输出配置。
			HtraApi.DET_StreamInfo_TypeDef StreamInfo = new HtraApi.DET_StreamInfo_TypeDef(); //当前配置下的DET数据相关信息，包括DET数据点数、字节数等。

			HtraApi.DET_ProfileDeInit(ref Device, ref DET_ProfileIn); //初始化配置DET模式的相关参数。

			DET_ProfileIn.CenterFreq_Hz = 1e9;									 //配置中心频率。
			DET_ProfileIn.RefLevel_dBm = 0;										 //配置参考电平。
			DET_ProfileIn.DecimateFactor = 2;									 //配置抽取倍数。
			DET_ProfileIn.TriggerSource = HtraApi.DET_TriggerSource_TypeDef.Bus; //配置触发源为内部总线触发。

			//配置触发模式。FixedPoints模式是触发信号的上升沿开始采样。采到TriggerLength个点后结束采样。Adaptive模式是触发信号的上升沿开始采样，下降沿结束采样。
			//使用Adaptive模式直接运行，使用FixedPoints模式则将 #if true 改为 #if false
#if true
			DET_ProfileIn.TriggerMode = HtraApi.TriggerMode_TypeDef.Adaptive;
#else
			//配置FixedPoints模式相关参数
			DET_ProfileIn.TriggerMode = HtraApi.TriggerMode_TypeDef.FixedPoints;    
			DET_ProfileIn.TriggerLength = 16242;                                    //配置单次触发采集的点数。仅当TriggerMode设置为FixedPoints时生效。
#endif
			Status = HtraApi.DET_Configuration(ref Device, ref DET_ProfileIn, ref DET_ProfileOut, ref StreamInfo); //通过调用此函数下发DET模式的相关配置。
			if (Status == 0)
			{
				System.Console.WriteLine("configuration delievery succeeded");
			}
			else
			{
				System.Console.WriteLine("SWP_Configuration call is incorrect,Status = " + Status);
				HtraApi.Device_Close(ref Device);
			}

			#endregion

			#region 3 数据采集
			float[] NormalizedPowerStream = new float[StreamInfo.PacketSamples];				 //存放局部幅度数据。
			float ScaleToV = 0;                                                                  //此参数为绝对幅度（V单位）的比例因子。
			HtraApi.DET_TriggerInfo_TypeDef TriggerInfo = new HtraApi.DET_TriggerInfo_TypeDef(); //触发信息。
			HtraApi.MeasAuxInfo_TypeDef MeasAuxInfo = new HtraApi.MeasAuxInfo_TypeDef();         //测量数据的辅助信息，包括：功率最大值索引、功率最大值、设备温度、经纬度、绝对时间戳等。

#if true

			Status = HtraApi.DET_BusTriggerStart(ref Device); //调用DET_BusTriggerStart触发设备。若触发源为外部触发，则不需要调用此函数。
			while (true)
			{
				Status = HtraApi.DET_GetPowerStream(ref Device, NormalizedPowerStream, ref ScaleToV, ref TriggerInfo, ref MeasAuxInfo); //获取DET数据及触发信息。
				if (Status == 0)
				{
					//UserCode here

					//下面范例是将DET数据的单位转换成dBm
					//范例开始
					for (int i = 0; i < StreamInfo.PacketSamples; i++)
					{
						NormalizedPowerStream[i] = (float)(10 * Math.Log10(20 * Math.Pow(NormalizedPowerStream[i] * ScaleToV, 2)));
					}
					//范例结束
				}

				/*获取数据失败时，返回错误提示，发生以下错误时，建议按照提示进行操作*/
				else
				{
					switch (Status)
					{
						case HtraApi.APIRETVAL_WARNING_BusTimeOut:
							System.Console.WriteLine("Warning - Get data timed out, check if the trigger source is triggered normally");
							break;      //DET_GetPowerStream如果返回值为-14，建议重新配置参数后再获取。

						case HtraApi.APIRETVAL_WARNING_IFOverflow:
							System.Console.WriteLine("WARNING - IF saturation is recommended to be reconfigured, reference level <= signal power");
							break;      // DET_GetPowerStream如果返回值为-12，建议重新配置参数获取
						default:
							System.Console.WriteLine("If the status of the get function is incorrect, check the process of getting data");
							break;
					}
					System.Console.WriteLine("Status = " + Status);
					break;

				}
				for (int k = 0; k < (int)StreamInfo.PacketSamples; k++)
				{
					System.Console.WriteLine(NormalizedPowerStream[k].ToString());
				}
			}


#else
			while (true)
			{
				Status = HtraApi.DET_BusTriggerStart(ref Device); //调用DET_BusTriggerStart触发设备。若触发源为外部触发，则不需要调用此函数。
				for (int j = 0; j < (int)StreamInfo.PacketCount; j++)
				{
					Status = HtraApi.DET_GetPowerStream(ref Device, NormalizedPowerStream, ref ScaleToV, ref TriggerInfo, ref MeasAuxInfo); //获取DET数据及触发信息。
					if (Status == 0)
					{
						//UserCode here

						//下面范例是将DET数据的单位转换成dBm
						//范例开始
						UInt32 points = StreamInfo.PacketSamples; //每包数据个数
						if (j == (int)StreamInfo.PacketCount - 1 && StreamInfo.StreamSamples % StreamInfo.PacketSamples != 0)
						{       //最后一个包判断，是最后一个包，且最后一个不满
							points = (UInt32)StreamInfo.StreamSamples % StreamInfo.PacketSamples; //最后一个包内数据个数计算
						}
						for (int i = 0; i < points; i++)
						{
							NormalizedPowerStream[i + StreamInfo.PacketSamples * j] = (float)(10 * Math.Log10(20 * Math.Pow(NormalizedPowerStream[i] * ScaleToV, 2)));
						}
						//范例结束
					}

					/*获取数据失败时，返回错误提示，发生以下错误时，建议按照提示进行操作*/
					else
					{
						switch (Status)
						{
							case HtraApi.APIRETVAL_WARNING_BusTimeOut:
								System.Console.WriteLine("Warning - Get data timed out, check if the trigger source is triggered normally");
								break;      //DET_GetPowerStream如果返回值为-14，建议重新配置参数后再获取。

							case HtraApi.APIRETVAL_WARNING_IFOverflow:
								System.Console.WriteLine("WARNING - IF saturation is recommended to be reconfigured, reference level <= signal power");
								break;      // DET_GetPowerStream如果返回值为-12，建议重新配置参数获取
							default:
								System.Console.WriteLine("If the status of the get function is incorrect, check the process of getting data");
								break;
						}
						System.Console.WriteLine("Status = " + Status);
						break;

					}
					for (int k = 0; k < (int)DET_ProfileIn.TriggerLength; k++)
					{
						System.Console.WriteLine(NormalizedPowerStream[k].ToString());
					}
				}
			}
#endif

			#endregion

			#region 4 关闭
			Status = HtraApi.DET_BusTriggerStop(ref Device); //调用DET_BusTriggerStop停止触发设备。若触发源为外部触发，则不需要调用此函数。
			HtraApi.Device_Close(ref Device);
			#endregion
		}
	}
}
