﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HTRA_CSharp_Examples
{
    class ASG_CWOutput
    {
		public void Example()
		{
			#region 1 打开设备

			int Status = 0;              //函数的返回。
			IntPtr Device = IntPtr.Zero; //当前设备的内存地址。
			int DevNum = 0;              //指定设备号。

			HtraApi.BootProfile_TypeDef BootProfile = new HtraApi.BootProfile_TypeDef(); //启动配置结构体，包括物理接口、供电方式等。
			HtraApi.BootInfo_TypeDef BootInfo = new HtraApi.BootInfo_TypeDef();          //启动信息结构体，包括设备信息、USB速率等。

			BootProfile.DevicePowerSupply = HtraApi.DevicePowerSupply_TypeDef.USBPortAndPowerPort; //使用USB数据端口及独立电源端口双供电。

			//设备数据接口为USB时直接运行，为网口时将 #if true 改为 #if false
#if true
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.USB;
#else
			//配置网络相关参数
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.ETH;
			BootProfile.ETH_IPVersion = HtraApi.IPVersion_TypeDef.IPv4;
			BootProfile.ETH_RemotePort = 5000;
			BootProfile.ETH_ReadTimeOut = 5000;
			BootProfile.ETH_IPAddress = new byte[16];
			BootProfile.ETH_IPAddress[0] = 192;
			BootProfile.ETH_IPAddress[1] = 168;
			BootProfile.ETH_IPAddress[2] = 1;
			BootProfile.ETH_IPAddress[3] = 100;
#endif

			Status = HtraApi.Device_Open(ref Device, DevNum, ref BootProfile, ref BootInfo); //打开设备

			if (Status == 0)
			{
				System.Console.WriteLine("Device is opened successfully");
			}

			/*设备打开失败，返回错误提示，发生以下错误时，设备无法正常运行，建议按照提示操作后重新打开设备*/
			else
			{
				switch (Status)
				{
					case HtraApi.APIRETVAL_ERROR_BusOpenFailed:
						System.Console.WriteLine("Error - Check the device power supply, data cable connection and driver installation");
						return;

					case HtraApi.APIRETVAL_ERROR_RFACalFileIsMissing:
						System.Console.WriteLine("Error - RF calibration file is missing");
						return;

					case HtraApi.APIRETVAL_ERROR_IFACalFileIsMissing:
						System.Console.WriteLine("Error - IF calibration file is missing");
						return;

					case HtraApi.APIRETVAL_ERROR_DeviceConfigFileIsMissing:
						System.Console.WriteLine("Error - Configuration file missing");
						return;

					case HtraApi.APIRETVAL_ERROR_DeviceSpecFileIsMissing:
						System.Console.WriteLine("Error - Device specification file is missing");
						return;

					default:
						System.Console.WriteLine("Return other errors！ Status = " + Status);
						return;
				}
			}
			#endregion

			#region 2 配置参数
			HtraApi.SWP_Profile_TypeDef SWP_ProfileIn = new HtraApi.SWP_Profile_TypeDef();  //SWP输入配置，包括起始频率、终止频率、RBW、参考电平等。
			HtraApi.SWP_Profile_TypeDef SWP_ProfileOut = new HtraApi.SWP_Profile_TypeDef(); //SWP输出配置。
			HtraApi.SWP_TraceInfo_TypeDef TraceInfo = new HtraApi.SWP_TraceInfo_TypeDef();  //当前配置下的迹线信息，包括迹线点数、跳频点数等。

			HtraApi.SWP_ProfileDeInit(ref Device, ref SWP_ProfileIn); //初始化配置SWP模式的相关参数。

			SWP_ProfileIn.StartFreq_Hz = 1e9; //配置起始频率
			SWP_ProfileIn.StopFreq_Hz = 2e9;  //配置终止频率

			Status = HtraApi.SWP_Configuration(ref Device, ref SWP_ProfileIn, ref SWP_ProfileOut, ref TraceInfo); //下发SWP模式的相关配置。

			HtraApi.ASG_Profile_TypeDef ASG_ProfileIn = new HtraApi.ASG_Profile_TypeDef();  //ASG输入配置，包括信号源输出模式、各模式下频率，功率等参数设置。
			HtraApi.ASG_Profile_TypeDef ASG_ProfileOut = new HtraApi.ASG_Profile_TypeDef(); //ASG输出配置。
			HtraApi.ASG_Info_TypeDef ASG_Info = new HtraApi.ASG_Info_TypeDef();             //当前配置下扫描点数的信息。

			HtraApi.ASG_ProfileDeInit(ref Device, ref ASG_ProfileIn); //初始化配置ASG模式的相关参数

			//单音信号
			ASG_ProfileIn.CenterFreq_Hz = 1.51e9;
			ASG_ProfileIn.Level_dBm = -20;
			ASG_ProfileIn.Mode = HtraApi.ASG_Mode_TypeDef.ASG_FixedPoint;
			ASG_ProfileIn.Port = HtraApi.ASG_Port_TypeDef.ASG_Port_Internal;

			//频率扫描信号
			/*ASG_ProfileIn.StartFreq_Hz = 1.2e9;
            ASG_ProfileIn.StopFreq_Hz = 1.4e9;
            ASG_ProfileIn.StepFreq_Hz = 1e6;
            ASG_ProfileIn.Level_dBm = -20;
            ASG_ProfileIn.Mode = HtraApi.ASG_Mode_TypeDef.ASG_FrequencySweep;*/

			//功率扫描信号
			/*ASG_ProfileIn.CenterFreq_Hz = 1.6e9;
            ASG_ProfileIn.StartLevel_dBm = -30;
            ASG_ProfileIn.StopLevel_dBm = -20;
            ASG_ProfileIn.Mode = HtraApi.ASG_Mode_TypeDef.ASG_PowerSweep;*/

			HtraApi.ASG_Configuration(ref Device, ref ASG_ProfileIn, ref ASG_ProfileOut, ref ASG_Info); //通过调用此函数下发ASG模式的相关配置

			double[] Frequency = new double[TraceInfo.FullsweepTracePoints];			 //创建数组存放一整段频率数据
			float[] PowerSpec_dBm = new float[TraceInfo.FullsweepTracePoints];			 //创建数组存放一整段幅度数据
			HtraApi.MeasAuxInfo_TypeDef MeasAuxInfo = new HtraApi.MeasAuxInfo_TypeDef(); //测量数据的辅助信息

			#endregion

			#region 3 信号输出
			while (true)
			{
				Status = HtraApi.SWP_GetFullSweep(ref Device, Frequency, PowerSpec_dBm, ref MeasAuxInfo); //获取迹线
			}
			#endregion

			#region 4 关闭
			HtraApi.Device_Close(ref Device);
			#endregion
		}
	}
}
